/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.gc4s.input.combobox;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;

public class ExtendedJComboBox<T>
extends JComboBox<T> {
    private static final int WIDTH_MARGIN = 25;
    private static final long serialVersionUID = 1L;
    private boolean layingOut = false;
    private boolean autoAdjustWidth = false;
    private int maxItemWidth = 0;

    public ExtendedJComboBox() {
    }

    public ExtendedJComboBox(T[] items) {
        super(items);
    }

    public ExtendedJComboBox(ComboBoxModel<T> model) {
        super(model);
    }

    public void setAutoAdjustWidth(boolean wide) {
        this.autoAdjustWidth = wide;
        this.maxItemWidth = this.getWidestItemWidth();
    }

    private int getWidestItemWidth() {
        FontMetrics metrics = this.getFontMetrics();
        int widest = 0;
        for (int i = 0; i < this.getItemCount(); ++i) {
            Object item = this.getItemAt(i);
            int lineWidth = metrics.stringWidth(item.toString());
            widest = Math.max(widest, lineWidth);
        }
        return widest + 25;
    }

    private FontMetrics getFontMetrics() {
        Font font = this.getFont();
        return this.getFontMetrics(font);
    }

    private boolean isAutoAdjustWidth() {
        return this.autoAdjustWidth;
    }

    @Override
    public Dimension getSize() {
        Dimension dim = super.getSize();
        if (!this.layingOut && this.isAutoAdjustWidth()) {
            dim.width = Math.max(this.maxItemWidth, dim.width);
        }
        return dim;
    }

    @Override
    public void doLayout() {
        try {
            this.layingOut = true;
            super.doLayout();
        }
        finally {
            this.layingOut = false;
        }
    }
}

