/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.gc4s.dialog;

import java.awt.Font;
import java.awt.Window;
import java.util.Optional;
import javax.swing.JPanel;
import org.sing_group.gc4s.dialog.AbstractInputJDialog;
import org.sing_group.gc4s.input.FontConfigurationPanel;

public class FontConfigurationDialog
extends AbstractInputJDialog {
    private static final long serialVersionUID = 1L;
    private FontConfigurationPanel fontConfigurationPanel;
    private Optional<Font> selectedFont;

    public FontConfigurationDialog(Window parent) {
        super(parent);
    }

    public FontConfigurationDialog(Window parent, Font font) {
        super(parent);
        this.selectedFont = Optional.ofNullable(font);
        if (this.selectedFont.isPresent()) {
            this.fontConfigurationPanel.setSelectedFont(this.selectedFont.get());
        }
    }

    @Override
    protected String getDialogTitle() {
        return "Font configuration";
    }

    @Override
    protected String getDescription() {
        return "This dialog allows you to select a font type and size.";
    }

    @Override
    protected JPanel getInputComponentsPane() {
        this.fontConfigurationPanel = new FontConfigurationPanel();
        return this.fontConfigurationPanel;
    }

    public Font getSelectedFont() {
        return this.fontConfigurationPanel.getSelectedFont();
    }

    @Override
    public void setVisible(boolean b) {
        this.okButton.setEnabled(true);
        this.pack();
        super.setVisible(b);
    }
}

