/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.s2p.gui.samespots;

import es.uvigo.ei.sing.s2p.core.io.samespots.SameSpotsReportFileWriterConfiguration;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.sing_group.gc4s.event.DocumentAdapter;
import org.sing_group.gc4s.input.InputParameter;
import org.sing_group.gc4s.input.InputParametersPanel;

public class SameSpotsReportFileWriterConfigurationPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final String CONFIGURATION = "property.report.configuration";
    private InputParameter[] inputParameters;
    private JCheckBox includeMascotScoreCb = new JCheckBox("Mascot score", true);
    private JCheckBox includeTitleCb = new JCheckBox("Protein name", true);
    private JCheckBox includeAccession = new JCheckBox("Accession", true);
    private JCheckBox includePiValueCb = new JCheckBox("pI-Value", true);
    private JCheckBox includeProteinMwCb = new JCheckBox("Protein MW", true);
    private JCheckBox includeSpotsWithoutIdentifications = new JCheckBox("Include spots without associated identifications", true);
    private JCheckBox includeDuplicatedProteinNames = new JCheckBox("Include identifications with duplicated protein names", false);
    private JCheckBox includeMethodCb = new JCheckBox("Method", false);
    private JCheckBox includeMsCoverageCb = new JCheckBox("MS Coverage", false);
    private JCheckBox includePlatePositionCb = new JCheckBox("Plate position", false);
    private JCheckBox includeSourceCb = new JCheckBox("Source", false);
    private JCheckBox includeDifference = new JCheckBox("Difference", false);
    private JRadioButton copyReportRbtn = new JRadioButton("Copy", true);
    private JRadioButton overWriteRbtn = new JRadioButton("Overwrite", false);
    private JTextField fileSuffixTextField = new JTextField("_WithIdentifications");

    public SameSpotsReportFileWriterConfigurationPanel() {
        this.init();
    }

    private void init() {
        this.add((Component)new InputParametersPanel(this.getParameters()));
    }

    private void stateChanged(ItemEvent e) {
        this.stateChanged();
    }

    private void stateChanged() {
        PropertyChangeEvent event = new PropertyChangeEvent(this, CONFIGURATION, null, null);
        for (PropertyChangeListener pL : this.getPropertyChangeListeners(CONFIGURATION)) {
            pL.propertyChange(event);
        }
    }

    private static final String includeDescription(String property) {
        return "Whether " + property + " should be included in the report or not.";
    }

    private InputParameter[] getParameters() {
        this.inputParameters = new InputParameter[14];
        this.inputParameters[0] = new InputParameter("", (JComponent)this.includeMascotScoreCb, SameSpotsReportFileWriterConfigurationPanel.includeDescription("Mascot score"));
        this.inputParameters[1] = new InputParameter("", (JComponent)this.includeMethodCb, SameSpotsReportFileWriterConfigurationPanel.includeDescription("Method"));
        this.inputParameters[2] = new InputParameter("", (JComponent)this.includeMsCoverageCb, SameSpotsReportFileWriterConfigurationPanel.includeDescription("MS Coverage"));
        this.inputParameters[3] = new InputParameter("", (JComponent)this.includePlatePositionCb, SameSpotsReportFileWriterConfigurationPanel.includeDescription("Plate position"));
        this.inputParameters[4] = new InputParameter("", (JComponent)this.includeSourceCb, SameSpotsReportFileWriterConfigurationPanel.includeDescription("Source"));
        this.inputParameters[5] = new InputParameter("", (JComponent)this.includeDifference, SameSpotsReportFileWriterConfigurationPanel.includeDescription("Difference"));
        this.inputParameters[6] = new InputParameter("", (JComponent)this.includeTitleCb, SameSpotsReportFileWriterConfigurationPanel.includeDescription("Protein name"));
        this.inputParameters[7] = new InputParameter("", (JComponent)this.includeAccession, SameSpotsReportFileWriterConfigurationPanel.includeDescription("Accession"));
        this.inputParameters[8] = new InputParameter("", (JComponent)this.includePiValueCb, SameSpotsReportFileWriterConfigurationPanel.includeDescription("pI-Value"));
        this.inputParameters[9] = new InputParameter("", (JComponent)this.includeProteinMwCb, SameSpotsReportFileWriterConfigurationPanel.includeDescription("Protein MW"));
        this.inputParameters[10] = new InputParameter("", (JComponent)this.includeSpotsWithoutIdentifications, "Whether include spots without associated dentifications or not. If this option is selected, then spots without associated identifications will remain in the report.");
        this.inputParameters[11] = new InputParameter("", (JComponent)this.includeDuplicatedProteinNames, "Whether include identifications with duplicated protein names or not. If you select this option, then a row will be added for each duplicated protein name of each spot identifier.");
        this.inputParameters[12] = new InputParameter("", this.getFileModePanel(), "Whether overwrite original report files or make a copy of each one.");
        this.inputParameters[13] = new InputParameter("", this.getSuffixPanel(), "The suffix for adding to the copies of the original report files.");
        this.addListeners();
        return this.inputParameters;
    }

    private JComponent getFileModePanel() {
        JPanel fileModePanel = new JPanel();
        fileModePanel.setLayout(new GridLayout(1, 2));
        this.overWriteRbtn.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SameSpotsReportFileWriterConfigurationPanel.this.overWriteStateChanged(e);
            }
        });
        fileModePanel.add(this.copyReportRbtn);
        fileModePanel.add(this.overWriteRbtn);
        ButtonGroup fileModeGroup = new ButtonGroup();
        fileModeGroup.add(this.copyReportRbtn);
        fileModeGroup.add(this.overWriteRbtn);
        return fileModePanel;
    }

    private JComponent getSuffixPanel() {
        JPanel suffixPanel = new JPanel();
        suffixPanel.setLayout(new BoxLayout(suffixPanel, 0));
        suffixPanel.add(new JLabel("Files suffix"));
        suffixPanel.add(Box.createHorizontalStrut(10));
        suffixPanel.add(this.fileSuffixTextField);
        return suffixPanel;
    }

    private void overWriteStateChanged(ItemEvent e) {
        this.fileSuffixTextField.setEnabled(!this.overWriteRbtn.isSelected());
        this.stateChanged();
    }

    private void addListeners() {
        this.includeMascotScoreCb.addItemListener(this::stateChanged);
        this.includeTitleCb.addItemListener(this::stateChanged);
        this.includeMethodCb.addItemListener(this::stateChanged);
        this.includeMsCoverageCb.addItemListener(this::stateChanged);
        this.includePlatePositionCb.addItemListener(this::stateChanged);
        this.includeSourceCb.addItemListener(this::stateChanged);
        this.includeDifference.addItemListener(this::stateChanged);
        this.includeAccession.addItemListener(this::stateChanged);
        this.includePiValueCb.addItemListener(this::stateChanged);
        this.includeProteinMwCb.addItemListener(this::stateChanged);
        this.includeSpotsWithoutIdentifications.addItemListener(this::stateChanged);
        this.includeDuplicatedProteinNames.addItemListener(this::stateChanged);
        this.fileSuffixTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void removeUpdate(DocumentEvent e) {
                SameSpotsReportFileWriterConfigurationPanel.this.stateChanged();
            }

            public void insertUpdate(DocumentEvent e) {
                SameSpotsReportFileWriterConfigurationPanel.this.stateChanged();
            }
        });
    }

    public boolean isValidConfiguration() {
        return (this.includeMascotScoreCb.isSelected() || this.includeTitleCb.isSelected() || this.includeAccession.isSelected() || this.includePiValueCb.isSelected() || this.includeProteinMwCb.isSelected() || this.includeMethodCb.isSelected() || this.includeMsCoverageCb.isSelected() || this.includePlatePositionCb.isSelected() || this.includeSourceCb.isSelected() || this.includeDifference.isSelected()) && this.isValidFileMode();
    }

    private boolean isValidFileMode() {
        return this.overWriteRbtn.isSelected() || !this.fileSuffixTextField.getText().isEmpty();
    }

    public SameSpotsReportFileWriterConfiguration getSelectedConfiguration() {
        return new SameSpotsReportFileWriterConfiguration(this.includeMascotScoreCb.isSelected(), this.includeAccession.isSelected(), this.includeTitleCb.isSelected(), this.includePiValueCb.isSelected(), this.includeProteinMwCb.isSelected(), this.includeSpotsWithoutIdentifications.isSelected(), this.includeDuplicatedProteinNames.isSelected(), this.includeMethodCb.isSelected(), this.includeMsCoverageCb.isSelected(), this.includePlatePositionCb.isSelected(), this.includeSourceCb.isSelected(), this.includeDifference.isSelected(), this.overWriteRbtn.isSelected(), this.fileSuffixTextField.getText());
    }
}

