/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.s2p.gui.charts;

import es.uvigo.ei.sing.s2p.gui.UISettings;
import es.uvigo.ei.sing.s2p.gui.charts.DataSeries;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Paint;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.renderer.category.BoxAndWhiskerRenderer;
import org.jfree.data.statistics.BoxAndWhiskerCategoryDataset;
import org.jfree.data.statistics.DefaultBoxAndWhiskerCategoryDataset;

public class ChartDataSeriesPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    final DefaultBoxAndWhiskerCategoryDataset dataset = new DefaultBoxAndWhiskerCategoryDataset();
    private String title;
    private String xAxisTitle;
    private String yAxisTitle;
    private List<DataSeries> series;

    public ChartDataSeriesPanel(String title, String xAxisTitle, String yAxisTitle, List<DataSeries> series) {
        this.title = title;
        this.xAxisTitle = xAxisTitle;
        this.yAxisTitle = yAxisTitle;
        this.series = series;
        this.initComponent();
    }

    private void initComponent() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.createChartPanel(this.createDataset(), this.title, this.xAxisTitle, this.yAxisTitle, true));
    }

    private DefaultBoxAndWhiskerCategoryDataset createDataset() {
        DefaultBoxAndWhiskerCategoryDataset dataset = new DefaultBoxAndWhiskerCategoryDataset();
        for (int i = 0; i < this.series.size(); ++i) {
            dataset.add(this.series.get(i).getData(), (Comparable)((Object)this.series.get(i).getLabel()), (Comparable)((Object)""));
        }
        return dataset;
    }

    public ChartPanel createChartPanel(DefaultBoxAndWhiskerCategoryDataset dataset, String chartTitle, String xAxisTitle, String yAxisTitle, boolean legend) {
        JFreeChart boxAndWhiskerChart = ChartFactory.createBoxAndWhiskerChart((String)chartTitle, (String)xAxisTitle, (String)yAxisTitle, (BoxAndWhiskerCategoryDataset)dataset, (boolean)legend);
        CategoryPlot pl = (CategoryPlot)boxAndWhiskerChart.getPlot();
        pl.setRangeGridlinePaint((Paint)Color.GRAY);
        pl.setBackgroundPaint((Paint)UISettings.BG_COLOR);
        BoxAndWhiskerRenderer renderer = (BoxAndWhiskerRenderer)pl.getRenderer();
        for (Map.Entry<Integer, Color> entry : this.getSeriesColor().entrySet()) {
            renderer.setSeriesPaint(entry.getKey().intValue(), (Paint)entry.getValue());
        }
        renderer.setMaximumBarWidth(0.1);
        renderer.setFillBox(true);
        renderer.setMeanVisible(true);
        renderer.setMedianVisible(true);
        pl.setRangeGridlinesVisible(false);
        pl.setOutlineVisible(false);
        pl.getDomainAxis().setLabel(xAxisTitle);
        pl.getRangeAxis().setLabel(yAxisTitle);
        ChartPanel chartPanel = new ChartPanel(boxAndWhiskerChart);
        chartPanel.setPreferredSize(new Dimension(450, 270));
        return chartPanel;
    }

    private Map<Integer, Color> getSeriesColor() {
        HashMap<Integer, Color> seriesColor = new HashMap<Integer, Color>();
        for (int i = 0; i < this.series.size(); ++i) {
            seriesColor.put(i, this.series.get(i).getColor());
        }
        return seriesColor;
    }
}

