/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.gc4s.jsparklines.builders.barchartrenderer;

import java.awt.Color;
import javax.swing.JTable;
import no.uib.jsparklines.renderers.JSparklinesBarChartTableCellRenderer;
import org.jfree.chart.plot.PlotOrientation;
import org.sing_group.gc4s.jsparklines.JSparklinesBarChartTableCellRendererFactory;
import org.sing_group.gc4s.jsparklines.util.TableUtils;

public class MaximumColoredBarChartRendererBuilder {
    private int column;
    private JTable table;
    private Double maxValue;
    private PlotOrientation plotOrientation = JSparklinesBarChartTableCellRendererFactory.DEFAULT_ORIENTATION;
    private Color positiveValuesColor = JSparklinesBarChartTableCellRendererFactory.DEFAULT_POSITIVES_COLOR_LARGE_NUMBERS;

    public MaximumColoredBarChartRendererBuilder(JTable table, int column) {
        this.table = table;
        this.column = column;
    }

    public MaximumColoredBarChartRendererBuilder withPlotOrientation(PlotOrientation plotOrientation) {
        this.plotOrientation = plotOrientation;
        return this;
    }

    public MaximumColoredBarChartRendererBuilder withMaxValue(Double maxValue) {
        this.maxValue = maxValue;
        return this;
    }

    public MaximumColoredBarChartRendererBuilder withPositiveValuesColor(Color positiveValuesColor) {
        this.positiveValuesColor = positiveValuesColor;
        return this;
    }

    public JSparklinesBarChartTableCellRenderer build() {
        this.checkMaxValue();
        return JSparklinesBarChartTableCellRendererFactory.createMaxValueColoredBarChartRenderer(this.table, this.column, this.plotOrientation, this.maxValue, this.positiveValuesColor);
    }

    private void checkMaxValue() {
        if (this.maxValue == null) {
            this.maxValue = TableUtils.getMaxColumnValue(this.table, this.column);
        }
    }
}

