/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.s2p.core.io.samespots;

import es.uvigo.ei.sing.s2p.core.entities.SameSpotsThrehold;
import es.uvigo.ei.sing.s2p.core.entities.Sample;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class SameSpotsFileLoader {
    private static final int INDEX_SPOT = 0;
    private static final int INDEX_P = 1;
    private static final int INDEX_FOLD = 2;
    private static final int INDEX_FIRST_SAMPLE = 12;
    public static final SameSpotsThrehold DEFAULT_THRESHOLD = new SameSpotsThrehold();

    public static List<Sample> load(File file, SameSpotsThrehold threshold) throws IOException {
        Document doc = Jsoup.parse((File)file, (String)"UTF-8");
        Element table = (Element)((Element)doc.select("div.spotTable").get(0)).select("table").get(0);
        return SameSpotsFileLoader.parseSamples(table, threshold);
    }

    private static List<Sample> parseSamples(Element table, SameSpotsThrehold threshold) {
        List<String> sampleNames = SameSpotsFileLoader.extractSampleNames(table.select("thead").first());
        List<Map<String, Double>> sampleValues = SameSpotsFileLoader.extractSampleValues(table.select("tbody").first(), threshold, sampleNames.size());
        return SameSpotsFileLoader.createSamples(sampleNames, sampleValues);
    }

    private static List<Sample> createSamples(List<String> sampleNames, List<Map<String, Double>> sampleValues) {
        LinkedList<Sample> samples = new LinkedList<Sample>();
        for (int i = 0; i < sampleNames.size(); ++i) {
            samples.add(new Sample(sampleNames.get(i), sampleValues.get(i)));
        }
        return samples;
    }

    private static List<String> extractSampleNames(Element head) {
        Elements ths = ((Element)head.select("tr").get(1)).select("th");
        return ths.stream().map(Element::html).collect(Collectors.toList());
    }

    private static List<Map<String, Double>> extractSampleValues(Element first, SameSpotsThrehold threshold, int samplesCount) {
        LinkedList<Map<String, Double>> sampleValues = new LinkedList<Map<String, Double>>();
        for (int i = 0; i < samplesCount; ++i) {
            sampleValues.add(new HashMap());
        }
        first.select("tr").forEach(row -> {
            Elements tds = row.select("td");
            String spot = ((Element)tds.get(0)).html();
            double p = SameSpotsFileLoader.asDouble((Element)tds.get(1));
            double fold = SameSpotsFileLoader.asDouble((Element)tds.get(2));
            if (p <= threshold.getP() && fold >= threshold.getFold()) {
                for (int i = 0; i < samplesCount; ++i) {
                    double sampleValue = SameSpotsFileLoader.asDouble((Element)tds.get(i + 12));
                    ((Map)sampleValues.get(i)).put(spot, sampleValue);
                }
            }
        });
        return sampleValues;
    }

    private static double asDouble(Element s) {
        return Double.parseDouble(s.html().replaceAll(",", "."));
    }
}

