/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.aibench.core.operation.execution;

import es.uvigo.ei.aibench.core.operation.execution.ExecutionSession;
import es.uvigo.ei.aibench.core.operation.execution.IncomingEndPoint;
import es.uvigo.ei.aibench.core.operation.execution.IncomingEndPointForwarder;
import es.uvigo.ei.aibench.core.operation.execution.ResultsCollector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

class CollectorAdapter
implements ResultsCollector {
    private final ExecutionSession adapted;
    private List<IncomingEndPoint> incomingEndPoints;

    CollectorAdapter(ExecutionSession adapted, List<Map.Entry<Class<?>, Integer>> groupsSpecification) {
        this.adapted = adapted;
        int actual = 0;
        List<? extends IncomingEndPoint> forwardedTo = adapted.getIncomingEndpoints();
        ArrayList<IncomingEndPointForwarder> incoming = new ArrayList<IncomingEndPointForwarder>();
        for (Map.Entry<Class<?>, Integer> entry : groupsSpecification) {
            int n = entry.getValue();
            assert (n >= 1);
            incoming.add(new IncomingEndPointForwarder(forwardedTo.subList(actual, actual + n).toArray(new IncomingEndPoint[0])));
            actual += n;
        }
        assert (actual == forwardedTo.size());
        this.incomingEndPoints = Collections.unmodifiableList(incoming);
    }

    @Override
    public void finish() {
        this.adapted.finish();
    }

    @Override
    public void newResult(int index, Object result) {
        this.incomingEndPoints.get(index).call(result);
    }

    @Override
    public void crash(Throwable cause) {
    }
}

