/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.aibench.workbench.utilities;

import es.uvigo.ei.aibench.workbench.Workbench;
import es.uvigo.ei.aibench.workbench.utilities.TabCloseEvent;
import es.uvigo.ei.aibench.workbench.utilities.TabCloseListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;

public class CloseableJTabbedPane
extends JTabbedPane {
    private static final long serialVersionUID = 1L;
    private static final Border TAB_PANEL_BORDER = BorderFactory.createEmptyBorder(3, 1, 3, 1);
    private static final ImageIcon CLOSE_ICON = new ImageIcon(CloseableJTabbedPane.class.getResource("images/tabclose.png"));
    private static final Border CLOSE_BUTTON_BORDER = BorderFactory.createEmptyBorder(0, 10, 0, 0);
    private static final boolean DEFAULT_ADD_CLOSEABLE = true;
    private final Icon closeIcon;

    public CloseableJTabbedPane() {
        this(CLOSE_ICON);
    }

    public CloseableJTabbedPane(int tabPlacement) {
        this(CLOSE_ICON, tabPlacement);
    }

    public CloseableJTabbedPane(int tabPlacement, int tabLayoutPolicy) {
        this(CLOSE_ICON, tabPlacement, tabLayoutPolicy);
    }

    public CloseableJTabbedPane(Icon closeIcon) {
        this.closeIcon = closeIcon;
    }

    public CloseableJTabbedPane(Icon closeIcon, int tabPlacement) {
        super(tabPlacement);
        this.closeIcon = closeIcon;
    }

    public CloseableJTabbedPane(Icon closeIcon, int tabPlacement, int tabLayoutPolicy) {
        super(tabPlacement, tabLayoutPolicy);
        this.closeIcon = closeIcon;
    }

    public void addTabCloseListener(TabCloseListener listener) {
        this.listenerList.add(TabCloseListener.class, listener);
    }

    public void removeTabCloseListener(TabCloseListener listener) {
        this.listenerList.remove(TabCloseListener.class, listener);
    }

    public void fireTabClosingEvent(int index) {
        TabCloseEvent event = new TabCloseEvent(this, 2000, index);
        for (TabCloseListener listener : (TabCloseListener[])this.listenerList.getListeners(TabCloseListener.class)) {
            listener.tabClosing(event);
        }
        if (!event.isCancelled()) {
            this.remove(index);
        }
    }

    public boolean isCloseableTabAt(int index) {
        Component component = this.getTabComponentAt(index);
        return component != null && CloseTab.class.isInstance(component);
    }

    public void fireTabCloseEvent(int index) {
        TabCloseEvent event = new TabCloseEvent(this, 2001, index);
        for (TabCloseListener listener : (TabCloseListener[])this.listenerList.getListeners(TabCloseListener.class)) {
            listener.tabClosed(event);
        }
    }

    @Override
    public void addTab(String title, Component component) {
        this.addTab(title, component, true);
    }

    public void addTab(String title, Component component, boolean closeable) {
        super.addTab(title, component);
        int index = this.indexOfComponent(component);
        if (index != -1) {
            this.setTabComponentAt(index, this.getTabComponent(closeable));
        }
    }

    private Component getTabComponent(boolean closeable) {
        return closeable ? new CloseTab() : new TabPanel();
    }

    @Override
    public void addTab(String title, Icon icon, Component component) {
        super.addTab(title, icon, component);
        int index = this.indexOfComponent(component);
        if (index != -1) {
            this.setTabComponentAt(index, new CloseTab());
        }
    }

    @Override
    public void addTab(String title, Icon icon, Component component, String tip) {
        super.addTab(title, icon, component, tip);
        int index = this.indexOfComponent(component);
        if (index != -1) {
            this.setTabComponentAt(index, new CloseTab());
        }
    }

    @Override
    public void removeTabAt(int index) {
        super.removeTabAt(index);
        this.fireTabCloseEvent(index);
    }

    protected class CloseTab
    extends TabPanel {
        private static final long serialVersionUID = 1L;

        protected CloseTab() {
        }

        @Override
        protected void init() {
            super.init();
            this.add((Component)new CloseButton(), "East");
        }

        private void closeAllTabs() {
            for (int toRemove = CloseableJTabbedPane.this.getTabCount() - 1; toRemove >= 0; --toRemove) {
                CloseableJTabbedPane.this.fireTabClosingEvent(toRemove);
            }
        }

        private void closeCurrentButtonTab() {
            int index = CloseableJTabbedPane.this.indexOfTabComponent(this);
            CloseableJTabbedPane.this.fireTabClosingEvent(index);
        }

        private void closeOtherTabs() {
            int index = CloseableJTabbedPane.this.indexOfTabComponent(this);
            for (int toRemove = CloseableJTabbedPane.this.getTabCount() - 1; toRemove >= 0; --toRemove) {
                if (toRemove == index) continue;
                CloseableJTabbedPane.this.fireTabClosingEvent(toRemove);
            }
        }

        private class CloseButton
        extends JButton {
            private static final long serialVersionUID = 1L;

            public CloseButton() {
                super(CloseableJTabbedPane.this.closeIcon);
                this.setToolTipText("Close tab");
                this.setContentAreaFilled(false);
                this.setBorderPainted(false);
                this.setBorder(CLOSE_BUTTON_BORDER);
                this.setCursor(new Cursor(12));
                this.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        CloseTab.this.closeCurrentButtonTab();
                    }
                });
                if (this.mustShowPopupMenu()) {
                    this.setComponentPopupMenu(new JPopupMenu());
                }
            }

            private boolean mustShowPopupMenu() {
                String showCloseTabsMenu = Workbench.CONFIG.getProperty("documentviewer.show_close_tabs_menu");
                return showCloseTabsMenu != null && showCloseTabsMenu.equals("true");
            }

            @Override
            public JPopupMenu getComponentPopupMenu() {
                if (this.mustShowPopupMenu()) {
                    JPopupMenu toret = new JPopupMenu();
                    toret.add(new AbstractAction("Close all tabs"){
                        private static final long serialVersionUID = 1L;

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            CloseTab.this.closeAllTabs();
                        }
                    });
                    toret.add(new AbstractAction("Close this tab"){
                        private static final long serialVersionUID = 1L;

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            CloseTab.this.closeCurrentButtonTab();
                        }
                    });
                    toret.add(new AbstractAction("Close other tabs"){
                        private static final long serialVersionUID = 1L;

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            CloseTab.this.closeOtherTabs();
                        }

                        @Override
                        public boolean isEnabled() {
                            return CloseableJTabbedPane.this.getTabCount() > 1;
                        }
                    });
                    return toret;
                }
                return super.getComponentPopupMenu();
            }
        }
    }

    protected class TabLabel
    extends JLabel {
        private static final long serialVersionUID = 1L;
        private JComponent component;

        public TabLabel(JComponent component) {
            this.component = component;
        }

        @Override
        public Icon getIcon() {
            int i = CloseableJTabbedPane.this.indexOfTabComponent(this.component);
            return i == -1 ? null : CloseableJTabbedPane.this.getIconAt(i);
        }

        @Override
        public String getText() {
            int i = CloseableJTabbedPane.this.indexOfTabComponent(this.component);
            return i == -1 ? null : CloseableJTabbedPane.this.getTitleAt(i);
        }
    }

    protected class TabPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public TabPanel() {
            super(new BorderLayout());
            this.init();
        }

        protected void init() {
            this.setBorder(TAB_PANEL_BORDER);
            this.setOpaque(false);
            TabLabel label = new TabLabel(this);
            label.setVerticalTextPosition(0);
            this.add((Component)label, "Center");
        }
    }
}

