/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.vda.gui;

import es.uvigo.ei.sing.vda.core.RColors;
import es.uvigo.ei.sing.vda.core.VennDiagramCreator;
import es.uvigo.ei.sing.vda.core.VennDiagramDesign;
import es.uvigo.ei.sing.vda.core.entities.NamedRSet;
import es.uvigo.ei.sing.vda.core.io.SerializationVennDiagramDesignWriter;
import es.uvigo.ei.sing.vda.gui.SetInput;
import es.uvigo.ei.sing.vda.gui.UISettings;
import es.uvigo.ei.sing.vda.gui.components.ButtonTabComponent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.sing_group.gc4s.input.filechooser.JFileChooserPanel;
import org.sing_group.gc4s.input.filechooser.Mode;
import org.sing_group.gc4s.input.filechooser.SelectionMode;
import org.sing_group.gc4s.ui.icons.Icons;

public class VennDiagramAssistant
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final ImageIcon ICON_ADD = VennDiagramAssistant.getResource("icons/add.png");
    public static final ImageIcon ICON_R = VennDiagramAssistant.getResource("icons/r.png");
    public static final ImageIcon ICON_SAVE = VennDiagramAssistant.getResource("icons/save.png");
    public static final VennDiagramDesign DEFAULT_DESIGN = new VennDiagramDesign(Arrays.asList(new NamedRSet("Set 1", RColors.R_COLORS[0])));
    private VennDiagramDesign design;
    private JPanel northPane;
    private JSplitPane centerPane;
    private JPanel southPane;
    private JTextArea codeTA;
    private VennDiagramCreator vennDiagramCreator = VennDiagramCreator.getImplementations()[0];
    private List<SetInput> inputSets = new LinkedList<SetInput>();
    private JTabbedPane tabbedPane;
    private JComboBox<VennDiagramCreator> librarySelectionCmb;
    private JPanel librarySelectionPanel;
    private JFileChooserPanel fileChooserPanel;
    private JFileChooser fileChooser = new JFileChooser(System.getProperty("user.home"));

    public VennDiagramAssistant() {
        this(DEFAULT_DESIGN);
    }

    public VennDiagramAssistant(VennDiagramDesign design) {
        this.design = design;
        this.initComponent();
    }

    private void initComponent() {
        this.setLayout(new BorderLayout());
        this.setBackground(UISettings.BG_COLOR);
        this.add(this.getNorthPane(), "North");
        this.add(this.getCenterPane(), "Center");
        this.configure();
    }

    private void configure() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VennDiagramAssistant.this.centerPane.setDividerLocation(300);
            }
        });
    }

    private Component getNorthPane() {
        if (this.northPane == null) {
            this.northPane = new JPanel();
            this.northPane.setBackground(UISettings.BG_COLOR);
            this.northPane.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
            BoxLayout layout = new BoxLayout(this.northPane, 0);
            this.northPane.setLayout(layout);
            JButton addSet = new JButton(new AbstractAction("", ICON_ADD){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    VennDiagramAssistant.this.addSet();
                }
            });
            JButton generateRCode = new JButton(new AbstractAction("", ICON_R){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    VennDiagramAssistant.this.generateRCode();
                }
            });
            JButton saveButton = new JButton(new AbstractAction("", ICON_SAVE){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    VennDiagramAssistant.this.saveDesign();
                }
            });
            this.northPane.add(this.getLibrarySelectionPanel());
            this.northPane.add(Box.createHorizontalStrut(20));
            this.northPane.add(this.getFileChooserSelectionPanel());
            this.northPane.add(Box.createHorizontalGlue());
            this.northPane.add(addSet);
            this.northPane.add(generateRCode);
            this.northPane.add(saveButton);
        }
        return this.northPane;
    }

    private Component getLibrarySelectionPanel() {
        if (this.librarySelectionPanel == null) {
            this.librarySelectionPanel = new JPanel();
            BoxLayout layout = new BoxLayout(this.librarySelectionPanel, 0);
            this.librarySelectionPanel.setLayout(layout);
            this.librarySelectionPanel.setOpaque(false);
            this.librarySelectionPanel.add(new JLabel("R library: "));
            this.librarySelectionPanel.add(this.getLibrarySelectionComponent());
        }
        return this.librarySelectionPanel;
    }

    private Component getLibrarySelectionComponent() {
        if (this.librarySelectionCmb == null) {
            this.librarySelectionCmb = new JComboBox<VennDiagramCreator>(VennDiagramCreator.getImplementations());
            this.librarySelectionCmb.setMaximumSize(new Dimension(200, 50));
            this.librarySelectionCmb.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    this.libraryChanged();
                }
            });
        }
        return this.librarySelectionCmb;
    }

    private void libraryChanged() {
        this.vennDiagramCreator = (VennDiagramCreator)this.librarySelectionCmb.getSelectedItem();
    }

    private JComponent getFileChooserSelectionPanel() {
        if (this.fileChooserPanel == null) {
            this.fileChooserPanel = new JFileChooserPanel(Mode.SAVE, this.fileChooser, Icons.ICON_LOOKUP_16, "Image file ", "tiff", SelectionMode.FILES);
            this.fileChooserPanel.setMaximumSize(new Dimension(250, 50));
            this.fileChooserPanel.setBackground(UISettings.BG_COLOR);
            this.fileChooserPanel.setSelectedFile(new File(System.getProperty("user.home"), "venn-diagram.tiff"));
        }
        return this.fileChooserPanel;
    }

    private Component getCenterPane() {
        if (this.centerPane == null) {
            this.centerPane = new JSplitPane(0);
            this.centerPane.setBackground(UISettings.BG_COLOR);
            this.centerPane.setOneTouchExpandable(true);
            this.centerPane.setResizeWeight(0.5);
            this.tabbedPane = new JTabbedPane(){
                private static final long serialVersionUID = 1L;

                @Override
                public void addTab(String title, Component component) {
                    super.addTab(title, component);
                    this.addCloseButton(component);
                }

                private void addCloseButton(Component component) {
                    super.setTabComponentAt(super.indexOfComponent(component), new ButtonTabComponent(this, () -> VennDiagramAssistant.this.componentRemoved(component)));
                }
            };
            this.centerPane.setLeftComponent(this.tabbedPane);
            this.centerPane.setRightComponent(this.getSouthPane());
            this.addDesign();
        }
        return this.centerPane;
    }

    private void componentRemoved(Component component) {
        this.inputSets.remove(component);
    }

    private void addDesign() {
        this.design.getSets().forEach(s -> {
            SetInput component = this.getSetInputComponent((NamedRSet<String>)s);
            this.addSetInputComponent(s.getName(), component);
        });
    }

    private Component getSouthPane() {
        if (this.southPane == null) {
            this.southPane = new JPanel(new BorderLayout());
            this.southPane.setMinimumSize(new Dimension(100, 200));
            this.codeTA = new JTextArea();
            this.codeTA.setLineWrap(true);
            this.codeTA.setBorder(BorderFactory.createTitledBorder("R code"));
            this.codeTA.setFont(new Font("Monospaced", 0, 13));
            this.southPane.add((Component)new JScrollPane(this.codeTA), "Center");
        }
        return this.southPane;
    }

    private void addSet() {
        String nextSetName = this.getNextSetName();
        String nextSetColor = RColors.R_COLORS[this.tabbedPane.getTabCount() % RColors.R_COLORS.length];
        SetInput component = this.getSetInputComponent(new NamedRSet<String>(nextSetName, nextSetColor));
        this.addSetInputComponent(nextSetName, component);
    }

    private void addSetInputComponent(String nextSetName, SetInput component) {
        this.tabbedPane.addTab(nextSetName, component);
        this.tabbedPane.setSelectedComponent(component);
        this.inputSets.add(component);
    }

    private SetInput getSetInputComponent(NamedRSet<String> set) {
        SetInput component = new SetInput(set);
        component.onComponentNameChanged(() -> this.componentNameChanged(component));
        return component;
    }

    private void componentNameChanged(SetInput component) {
        this.tabbedPane.setTitleAt(this.tabbedPane.indexOfComponent(component), component.getSetName());
    }

    private String getNextSetName() {
        String nextSetName = "";
        int count = 1;
        while (!this.isAvailableSetName(nextSetName = "Set " + (this.tabbedPane.getTabCount() + count++))) {
        }
        return nextSetName;
    }

    private boolean isAvailableSetName(String setName) {
        return !this.getSets().stream().map(NamedRSet::getName).filter(n -> n.equals(setName)).findAny().isPresent();
    }

    private void generateRCode() {
        this.codeTA.setText(this.vennDiagramCreator.getRCode(this.getSets(), this.getParameters()));
        this.copyCodeToClipboard();
    }

    private void copyCodeToClipboard() {
        StringSelection selection = new StringSelection(this.codeTA.getText());
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(selection, selection);
    }

    private Map<String, String> getParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("property.output-file", this.filePathToR(this.fileChooserPanel.getSelectedFile().getAbsolutePath()));
        return parameters;
    }

    private String filePathToR(String absolutePath) {
        return absolutePath.replace('\\', '/');
    }

    private List<NamedRSet<String>> getSets() {
        return this.inputSets.stream().map(SetInput::getNamedRSet).collect(Collectors.toList());
    }

    private void saveDesign() {
        JFileChooser jfc = new JFileChooser();
        jfc.setFileSelectionMode(0);
        int result = jfc.showSaveDialog(this);
        if (result == 0) {
            File selectedFile = jfc.getSelectedFile();
            SerializationVennDiagramDesignWriter writer = new SerializationVennDiagramDesignWriter();
            try {
                writer.write(this.getVennDiagramDesign(), selectedFile);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, "An error occurred when saving to " + selectedFile.getAbsolutePath(), "Save error", 0);
            }
        }
    }

    private VennDiagramDesign getVennDiagramDesign() {
        return new VennDiagramDesign(this.getSets());
    }

    private static final ImageIcon getResource(String resource) {
        return new ImageIcon(VennDiagramAssistant.class.getResource(resource));
    }
}

