/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.gc4s.input.list;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.InvalidClassException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataListener;
import org.jdesktop.swingx.JXTextField;
import org.sing_group.gc4s.input.list.ExtendedDefaultListModel;
import org.sing_group.gc4s.input.list.JListPanel;
import org.sing_group.gc4s.utilities.builder.JButtonBuilder;

public class JInputList
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected static final ImageIcon ICON_ADD = new ImageIcon(JInputList.class.getResource("icons/add.png"));
    private JPanel northPanel;
    private JPanel inputPanel;
    private JXTextField elementTextField;
    private JButton addElementButton;
    private boolean listButtons;
    private boolean listFilter;
    private boolean allowRepetitions;
    private boolean elementIntroductionEnabled = false;
    private JListPanel<String> itemsListPanel;
    private JList<String> itemsList;
    private ExtendedDefaultListModel<String> itemsListModel;

    public JInputList() {
        this(false, false, false);
    }

    public JInputList(boolean listButtons, boolean listFilter, boolean allowRepetitions) {
        this.listButtons = listButtons;
        this.listFilter = listFilter;
        this.allowRepetitions = allowRepetitions;
        this.initComponent();
    }

    private void initComponent() {
        this.setLayout(new BorderLayout());
        this.add(this.getNorthPane(), "North");
        this.add(this.getItemsList(), "Center");
    }

    private Component getNorthPane() {
        if (this.northPanel == null) {
            this.northPanel = new JPanel();
            this.northPanel.setLayout(new GridLayout(0, 1));
            this.northPanel.add(this.getInputPane());
        }
        return this.northPanel;
    }

    private Component getInputPane() {
        if (this.inputPanel == null) {
            this.inputPanel = new JPanel(new BorderLayout());
            this.elementTextField = new JXTextField("Element", Color.LIGHT_GRAY);
            this.elementTextField.addActionListener(e -> this.addElementButton.doClick());
            this.elementTextField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent arg0) {
                }

                @Override
                public void insertUpdate(DocumentEvent arg0) {
                    JInputList.this.currentItemChanged();
                }

                @Override
                public void removeUpdate(DocumentEvent arg0) {
                    JInputList.this.currentItemChanged();
                }
            });
            this.addElementButton = JButtonBuilder.newJButtonBuilder().thatDoes(new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    JInputList.this.addElement();
                }
            }).withText("").withIcon(ICON_ADD).disabled().build();
            this.inputPanel.add((Component)this.elementTextField, "Center");
            this.inputPanel.add((Component)this.addElementButton, "East");
        }
        return this.inputPanel;
    }

    private Component getItemsList() {
        if (this.itemsListPanel == null) {
            this.itemsListModel = new ExtendedDefaultListModel();
            this.itemsList = new JList<String>(this.itemsListModel);
            try {
                this.itemsListPanel = this.createListPanel();
            }
            catch (InvalidClassException e) {
                throw new RuntimeException(e);
            }
        }
        return this.itemsListPanel;
    }

    private JListPanel<String> createListPanel() throws InvalidClassException {
        return new JListPanel<String>(this.itemsList, this.listButtons, this.listFilter);
    }

    private void currentItemChanged() {
        this.updateAddElementStatus();
    }

    private void updateAddElementStatus() {
        this.addElementButton.setEnabled(this.elementIntroductionEnabled && this.isValidInput());
    }

    private boolean isValidInput() {
        return !this.elementTextField.getText().equals("") && this.checkRepetitions();
    }

    private boolean checkRepetitions() {
        return this.allowRepetitions || !this.listContains(this.elementTextField.getText());
    }

    private boolean listContains(String text) {
        return Collections.list(this.itemsListModel.elements()).stream().filter(i -> i.equals(text)).findAny().isPresent();
    }

    private void addElement() {
        this.itemsListModel.addElement(this.elementTextField.getText());
        this.elementTextField.setText("");
        this.itemsList.updateUI();
    }

    public void addElements(String ... elements) {
        this.itemsListModel.addElements(Arrays.asList(elements));
        this.itemsList.updateUI();
    }

    public void addListDataListener(ListDataListener l) {
        this.itemsListModel.addListDataListener(l);
    }

    public List<String> getInputItems() {
        return Collections.list(this.itemsListModel.elements());
    }

    public JListPanel<String> getListPanel() {
        return this.itemsListPanel;
    }

    public void setElementIntroductionEnabled(boolean enabled) {
        this.elementIntroductionEnabled = enabled;
        this.updateAddElementStatus();
        this.updateTextFieldStatus();
    }

    private void updateTextFieldStatus() {
        this.elementTextField.setEnabled(this.elementIntroductionEnabled);
    }
}

