/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.gc4s.input;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.stream.Stream;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class RangeInputPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String MINIMUM_VALUE = "Minimum value";
    private static final String MAXIMUM_VALUE = "Maximum value";
    private int min;
    private int max;
    private JLabel minValueLabel;
    private String minValueLabelText;
    private JSlider minValueSlider;
    private JLabel maxValueLabel;
    private String maxValueLabelText;
    private JSlider maxValueSlider;

    public RangeInputPanel(int min, int max) {
        this(min, max, MINIMUM_VALUE, MAXIMUM_VALUE);
    }

    public RangeInputPanel(int min, int max, String minLabel, String maxLabel) {
        this.min = min;
        this.max = max;
        this.minValueLabelText = minLabel;
        this.maxValueLabelText = maxLabel;
        this.initComponent();
    }

    private void initComponent() {
        this.setLayout(new GridLayout(1, 2));
        this.add(this.getMinPanel(), "West");
        this.add(this.getMaxPanel(), "East");
        this.initializeSliders();
    }

    private Component getMinPanel() {
        JPanel minPanel = new JPanel(new BorderLayout());
        this.minValueLabel = new JLabel(this.minValueLabelText);
        this.minValueSlider = new JSlider(this.min, this.max, this.min);
        minPanel.add((Component)this.minValueLabel, "North");
        minPanel.add((Component)this.minValueSlider, "Center");
        return minPanel;
    }

    private Component getMaxPanel() {
        JPanel maxPanel = new JPanel(new BorderLayout());
        this.maxValueLabel = new JLabel(this.maxValueLabelText);
        this.maxValueSlider = new JSlider(this.min, this.max, this.max);
        maxPanel.add((Component)this.maxValueLabel, "North");
        maxPanel.add((Component)this.maxValueSlider, "Center");
        return maxPanel;
    }

    private void initializeSliders() {
        this.minValueSlider.setPaintTicks(true);
        this.minValueSlider.setPaintLabels(true);
        this.minValueSlider.setMajorTickSpacing(1);
        this.minValueSlider.setMinorTickSpacing(1);
        this.minValueSlider.addChangeListener(e -> {
            if (this.minValueSlider.getValue() > this.maxValueSlider.getValue()) {
                this.maxValueSlider.setValue(this.minValueSlider.getValue());
            }
            this.rangeChanged();
        });
        this.maxValueSlider.setPaintTicks(true);
        this.maxValueSlider.setPaintLabels(true);
        this.maxValueSlider.setMajorTickSpacing(1);
        this.maxValueSlider.setMinorTickSpacing(1);
        this.maxValueSlider.addChangeListener(e -> {
            if (this.maxValueSlider.getValue() < this.minValueSlider.getValue()) {
                this.minValueSlider.setValue(this.maxValueSlider.getValue());
            }
            this.rangeChanged();
        });
    }

    public int getMinValue() {
        return this.minValueSlider.getValue();
    }

    public int getMaxValue() {
        return this.maxValueSlider.getValue();
    }

    private void rangeChanged() {
        Stream.of(this.getListeners(ChangeListener.class)).forEach(l -> l.stateChanged(new ChangeEvent(this)));
    }

    public synchronized void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public synchronized void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }
}

