/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.s2p.gui.components.dialog;

import es.uvigo.ei.sing.s2p.core.entities.Condition;
import es.uvigo.ei.sing.s2p.core.entities.Pair;
import es.uvigo.ei.sing.s2p.core.operations.SpotSummaryOperations;
import es.uvigo.ei.sing.s2p.gui.components.dialog.AbstractFileInputJDialog;
import java.awt.Window;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.sing_group.gc4s.input.InputParameter;
import org.sing_group.gc4s.input.InputParametersPanel;
import org.sing_group.gc4s.input.combobox.ComboBoxItem;
import org.sing_group.gc4s.input.text.DoubleTextField;

public class ConditionSelectionDialog
extends AbstractFileInputJDialog {
    private static final long serialVersionUID = 1L;
    private InputParametersPanel inputParametersPanel;
    private InputParameter[] parameters;
    private List<Condition> conditions;
    private JComboBox<SpotSummaryOperations.DifferentialSpotFunction> differentialSpotFunctionCmb;
    private DoubleTextField pValue;
    private JCheckBox correctPvalue;
    private JComboBox<ComboBoxItem<Condition>> condition1Cmb;
    private JComboBox<ComboBoxItem<Condition>> condition2Cmb;

    public ConditionSelectionDialog(Window parent, List<Condition> conditions) {
        super(parent);
        this.conditions = conditions;
        this.configure();
    }

    private void configure() {
        this.getItemsList().forEach(this.condition1Cmb::addItem);
        this.getItemsList().forEach(this.condition2Cmb::addItem);
        if (this.conditions.size() > 0) {
            this.condition1Cmb.setSelectedIndex(0);
            this.condition2Cmb.setSelectedIndex(1);
        }
    }

    private List<ComboBoxItem<Condition>> getItemsList() {
        return this.conditions.stream().map(c -> new ComboBoxItem(c, c.getName())).collect(Collectors.toList());
    }

    protected String getDialogTitle() {
        return "Select conditions";
    }

    protected String getDescription() {
        return "This dialog allows you to select two conditions.";
    }

    protected JPanel getInputComponentsPane() {
        this.inputParametersPanel = new InputParametersPanel(this.getParameters());
        return this.inputParametersPanel;
    }

    private InputParameter[] getParameters() {
        this.parameters = new InputParameter[5];
        this.parameters[0] = this.createCondition1Parameter();
        this.parameters[1] = this.createCondition2Parameter();
        this.parameters[2] = this.createFunctionParameter();
        this.parameters[3] = this.createPvalueParameter();
        this.parameters[4] = this.createCorrectPvalueParameter();
        return this.parameters;
    }

    private InputParameter createCondition1Parameter() {
        this.condition1Cmb = new JComboBox();
        return new InputParameter("Condition 1", this.condition1Cmb, "First condition to compare.");
    }

    private InputParameter createCondition2Parameter() {
        this.condition2Cmb = new JComboBox();
        return new InputParameter("Condition 2", this.condition2Cmb, "Second condition to compare.");
    }

    private InputParameter createFunctionParameter() {
        this.differentialSpotFunctionCmb = new JComboBox<SpotSummaryOperations.DifferentialSpotFunction>(SpotSummaryOperations.DifferentialSpotFunction.values());
        return new InputParameter("Function", this.differentialSpotFunctionCmb, "Function to find differentially expressed spots.");
    }

    private InputParameter createPvalueParameter() {
        this.pValue = new DoubleTextField(0.05);
        return new InputParameter("p-value", (JComponent)this.pValue, "Maximum p-value allowed.");
    }

    private InputParameter createCorrectPvalueParameter() {
        this.correctPvalue = new JCheckBox();
        this.correctPvalue.setSelected(true);
        return new InputParameter("Correct p-value", (JComponent)this.correctPvalue, "Wether p-values must be corrected to take care ofmultiple comparisons. Corrections are done usingBenjamini-Hochberg FDR correction.");
    }

    public void setVisible(boolean b) {
        this.okButton.setEnabled(true);
        this.pack();
        super.setVisible(b);
    }

    public double getSelectedPvalue() {
        return this.pValue.getValue();
    }

    public boolean isCorrectPvalue() {
        return this.correctPvalue.isSelected();
    }

    public Pair<Condition, Condition> getSelectedConditions() {
        return new Pair((Object)this.getCondition1(), (Object)this.getCondition2());
    }

    private Condition getCondition1() {
        ComboBoxItem item = (ComboBoxItem)this.condition1Cmb.getSelectedItem();
        return (Condition)item.getItem();
    }

    private Condition getCondition2() {
        ComboBoxItem item = (ComboBoxItem)this.condition2Cmb.getSelectedItem();
        return (Condition)item.getItem();
    }

    public SpotSummaryOperations.DifferentialSpotFunction getDiferentialSpotFunction() {
        return (SpotSummaryOperations.DifferentialSpotFunction)this.differentialSpotFunctionCmb.getSelectedItem();
    }
}

