/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.s2p.gui.spots.heatmap;

import es.uvigo.ei.sing.s2p.gui.spots.heatmap.SpotRenderer;
import java.awt.Window;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.sing_group.gc4s.dialog.AbstractInputJDialog;
import org.sing_group.gc4s.input.InputParameter;
import org.sing_group.gc4s.input.InputParametersPanel;

public class JHeatMapConfigurationDialog
extends AbstractInputJDialog {
    private static final long serialVersionUID = 1L;
    private InputParameter[] parameters;
    private JCheckBox showSampleLabel;
    private JCheckBox showSpotName;
    private JComboBox<SpotRenderer.IdentificationsMode> identificationModeCmb;
    private boolean spotCustomization;

    public JHeatMapConfigurationDialog(Window parent, boolean spotCustomization) {
        super(parent);
        this.spotCustomization = spotCustomization;
        this.configure();
    }

    private void configure() {
        this.parameters[1].getInput().setEnabled(this.spotCustomization);
        this.parameters[2].getInput().setEnabled(this.spotCustomization);
    }

    protected String getDialogTitle() {
        return "Customize heatmap";
    }

    protected String getDescription() {
        return "This dialog allows you to select which information is used for heatmap rows.";
    }

    protected JPanel getInputComponentsPane() {
        return new InputParametersPanel(this.getParameters());
    }

    private InputParameter[] getParameters() {
        this.parameters = new InputParameter[3];
        this.parameters[0] = this.getShowSampleLabelsParameter();
        this.parameters[1] = this.getShowSpotNameParameter();
        this.parameters[2] = this.getShowIdentificationModeParameter();
        return this.parameters;
    }

    private InputParameter getShowSpotNameParameter() {
        return new InputParameter("Show spot name", this.getShowSpotNameComponent(), "Wether the spot name must be shown or not.");
    }

    private JComponent getShowSpotNameComponent() {
        this.showSpotName = new JCheckBox();
        this.showSpotName.setSelected(true);
        return this.showSpotName;
    }

    private InputParameter getShowIdentificationModeParameter() {
        return new InputParameter("Show identifications", this.getShowIdentificationsComponent(), "Type of identifications to show.");
    }

    private JComponent getShowIdentificationsComponent() {
        this.identificationModeCmb = new JComboBox<SpotRenderer.IdentificationsMode>(SpotRenderer.IdentificationsMode.values());
        return this.identificationModeCmb;
    }

    private InputParameter getShowSampleLabelsParameter() {
        return new InputParameter("Show sample labels", this.getShowSampleLabelsComponent(), "Wether the sample labels must be shown or not.");
    }

    private JComponent getShowSampleLabelsComponent() {
        this.showSampleLabel = new JCheckBox();
        this.showSampleLabel.setSelected(false);
        return this.showSampleLabel;
    }

    public SpotRenderer getSelectedSpotRenderer() {
        return new SpotRenderer(this.getIdentificationsMode(), this.isShowSpotName());
    }

    private SpotRenderer.IdentificationsMode getIdentificationsMode() {
        return (SpotRenderer.IdentificationsMode)((Object)this.identificationModeCmb.getSelectedItem());
    }

    private boolean isShowSpotName() {
        return this.showSpotName.isSelected();
    }

    public boolean isShowSampleLabels() {
        return this.showSampleLabel.isSelected();
    }

    public void setVisible(boolean b) {
        this.okButton.setEnabled(true);
        this.pack();
        super.setVisible(b);
    }
}

