/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import com.sun.deploy.config.Platform;

public final class WinRegistry {
    public static final int HKEY_CLASSES_ROOT = Integer.MIN_VALUE;
    public static final int HKEY_CURRENT_USER = -2147483647;
    public static final int HKEY_LOCAL_MACHINE = -2147483646;
    public static final int HKEY_USERS = -2147483645;
    public static final int HKEY_PERFORMANCE_DATA = -2147483644;
    public static final int HKEY_CURRENT_CONFIG = -2147483643;
    public static final int HKEY_DYN_DATA = -2147483642;
    static final int KEY_QUERY_VALUE = 1;
    static final int KEY_SET_VALUE = 2;
    static final int KEY_CREATE_SUB_KEY = 4;
    static final int KEY_ENUMERATE_SUB_KEYS = 8;
    static final int KEY_NOTIFY = 16;
    static final int KEY_CREATE_LINK = 32;
    static final int KEY_READ = 131097;
    static final int KEY_WRITE = 131078;
    static final int KEY_EXECUTE = 131097;
    static final int KEY_ALL_ACCESS = 983103;
    static final int REG_OPTION_RESERVED = 0;
    static final int REG_OPTION_NON_VOLATILE = 0;
    static final int REG_OPTION_VOLATILE = 1;
    static final int REG_OPTION_CREATE_LINK = 2;
    static final int REG_OPTION_BACKUP_RESTORE = 4;
    static final int REG_OPTION_OPEN_LINK = 8;
    static final int REG_LEGAL_OPTION = 15;
    static final int REG_CREATED_NEW_KEY = 1;
    static final int REG_OPENED_EXISTING_KEY = 2;
    static final int REG_WHOLE_HIVE_VOLATILE = 1;
    static final int REG_REFRESH_HIVE = 2;
    static final int REG_NO_LAZY_FLUSH = 4;
    static final int REG_NOTIFY_CHANGE_NAME = 1;
    static final int REG_NOTIFY_CHANGE_ATTRIBUTES = 2;
    static final int REG_NOTIFY_CHANGE_LAST_SET = 4;
    static final int REG_NOTIFY_CHANGE_SECURITY = 8;
    static final int REG_LEGAL_CHANGE_FILTER = 15;
    static final int REG_NONE = 0;
    static final int REG_SZ = 1;
    static final int REG_EXPAND_SZ = 2;
    static final int REG_BINARY = 3;
    static final int REG_DWORD = 4;
    static final int REG_DWORD_LITTLE_ENDIAN = 4;
    static final int REG_DWORD_BIG_ENDIAN = 5;
    static final int REG_LINK = 6;
    static final int REG_MULTI_SZ = 7;
    static final int REG_RESOURCE_LIST = 8;
    static final int REG_FULL_RESOURCE_DESCRIPTOR = 9;
    static final int REG_RESOURCE_REQUIREMENTS_LIST = 10;

    static native void initIDs();

    static native int sysOpenKey(int var0, String var1, int var2);

    static native int sysCloseKey(int var0);

    static native KeyValue sysQueryKey(int var0, String var1);

    static native int sysCreateKey(int var0, String var1, int var2);

    static native boolean sysSetStringValue(int var0, String var1, String var2);

    static native boolean sysDeleteKey(int var0, String var1);

    static native boolean sysReboot();

    public static native String getWindowsDirectory();

    public static Object get(int n, String string, String string2) {
        int n2 = WinRegistry.sysOpenKey(n, string, 131097);
        if (n2 != 0) {
            KeyValue keyValue = WinRegistry.sysQueryKey(n2, string2);
            WinRegistry.sysCloseKey(n2);
            if (keyValue != null) {
                return keyValue.getValue();
            }
        }
        return null;
    }

    public static String getString(int n, String string, String string2) {
        Object object = WinRegistry.get(n, string, string2);
        return object instanceof String ? (String)object : null;
    }

    public static Integer getInteger(int n, String string, String string2) {
        Object object = WinRegistry.get(n, string, string2);
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            if (byArray.length == 4 && byArray[1] == 0 && byArray[2] == 0 && byArray[3] == 0) {
                return new Integer(byArray[0]);
            }
            return null;
        }
        return null;
    }

    public static boolean setStringValue(int n, String string, String string2, String string3) {
        boolean bl = false;
        int n2 = WinRegistry.sysCreateKey(n, string, 131078);
        if (n2 != 0) {
            bl = WinRegistry.sysSetStringValue(n2, string2, string3);
            WinRegistry.sysCloseKey(n2);
        }
        return bl;
    }

    public static boolean doesSubKeyExist(int n, String string) {
        int n2 = WinRegistry.sysOpenKey(n, string, 131097);
        if (n2 != 0) {
            WinRegistry.sysCloseKey(n2);
            return true;
        }
        return false;
    }

    public static boolean deleteKey(int n, String string) {
        return WinRegistry.sysDeleteKey(n, string);
    }

    public static boolean doReboot() {
        return WinRegistry.sysReboot();
    }

    static {
        Platform.get().loadDeployNativeLib();
        WinRegistry.initIDs();
    }

    static class KeyValue {
        private final int type;
        private Object value = null;

        KeyValue(int n, Object object) {
            this.type = n;
            this.value = object;
        }

        public int getType() {
            return this.type;
        }

        public Object getValue() {
            switch (this.type) {
                case 1: {
                    return (String)this.value;
                }
                case 4: {
                    return (Integer)this.value;
                }
            }
            return (byte[])this.value;
        }
    }
}

