/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.gc4s.list;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.InvalidClassException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.sing_group.gc4s.ComponentFactory;
import org.sing_group.gc4s.list.ExtendedDefaultListModel;
import org.sing_group.gc4s.list.FilteredListModel;
import org.sing_group.gc4s.list.JListPanel;
import org.sing_group.gc4s.ui.CenteredJPanel;

public class JParallelListsPanel<E>
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected static final ImageIcon ICON_ARROW_RIGHT = new ImageIcon(JParallelListsPanel.class.getResource("icons/right.png"));
    protected static final ImageIcon ICON_ARROW_LEFT = new ImageIcon(JParallelListsPanel.class.getResource("icons/left.png"));
    private JListPanel<E> left;
    private JListPanel<E> right;
    private AbstractAction actionMoveLeft;
    private AbstractAction actionMoveRight;
    private JButton btnMoveRight;
    private JButton btnMoveLeft;
    private String leftTitle;
    private String rightTitle;

    public JParallelListsPanel(JList<E> left, JList<E> right) throws InvalidClassException {
        this(left, right, true, false);
    }

    public JParallelListsPanel(JList<E> left, JList<E> right, boolean buttons, boolean filter) throws InvalidClassException {
        this(left, right, "", "", buttons, filter);
    }

    public JParallelListsPanel(JList<E> left, JList<E> right, String leftTitle, String rightTitle, boolean buttons, boolean filter) throws InvalidClassException {
        this.leftTitle = leftTitle;
        this.rightTitle = rightTitle;
        this.left = new JListPanel<E>(left, buttons, filter);
        this.right = new JListPanel<E>(right, buttons, filter);
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.add(this.getLeftList(), "West");
        this.add(this.getCenterComponent(), "Center");
        this.add(this.getRightList(), "East");
        this.addListeners();
    }

    private Component getLeftList() {
        if (this.leftTitle != null && !this.leftTitle.equals("")) {
            this.left.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), this.leftTitle));
        }
        return this.left;
    }

    private Component getRightList() {
        if (this.rightTitle != null && !this.rightTitle.equals("")) {
            this.right.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), this.rightTitle));
        }
        return this.right;
    }

    private Component getCenterComponent() {
        this.actionMoveLeft = new AbstractAction("Move left", ICON_ARROW_LEFT){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JParallelListsPanel.this.moveLeftSelectedElement();
            }
        };
        this.actionMoveRight = new AbstractAction("Move right", ICON_ARROW_RIGHT){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JParallelListsPanel.this.moveRightSelectedElement();
            }
        };
        this.btnMoveLeft = ComponentFactory.createButton(this.actionMoveLeft, false, "Moves the selected element to the left list", false);
        this.btnMoveRight = ComponentFactory.createButton(this.actionMoveRight, false, "Moves the selected element to the right list", false);
        JPanel buttons = new JPanel(new GridLayout(2, 1));
        buttons.add(this.btnMoveLeft);
        buttons.add(this.btnMoveRight);
        return new CenteredJPanel(buttons);
    }

    protected void moveRightSelectedElement() {
        this.moveSelectedElements(this.left.getList(), this.right.getList());
        this.checkLeftListSelection();
    }

    protected void moveLeftSelectedElement() {
        this.moveSelectedElements(this.right.getList(), this.left.getList());
        this.checkRightListSelection();
    }

    private void moveSelectedElements(JList<E> source, JList<E> dest) {
        FilteredListModel sFLM = (FilteredListModel)source.getModel();
        ExtendedDefaultListModel sEDLM = (ExtendedDefaultListModel)sFLM.getSourceListModel();
        FilteredListModel dFLM = (FilteredListModel)dest.getModel();
        ExtendedDefaultListModel dEDLM = (ExtendedDefaultListModel)dFLM.getSourceListModel();
        for (E sV : source.getSelectedValuesList()) {
            sEDLM.removeElement(sV);
            dEDLM.addElement(sV);
        }
        source.clearSelection();
        source.updateUI();
        dest.updateUI();
    }

    private void addListeners() {
        this.left.getList().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                JParallelListsPanel.this.checkLeftListSelection();
            }
        });
        this.right.getList().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                JParallelListsPanel.this.checkRightListSelection();
            }
        });
    }

    protected void checkLeftListSelection() {
        int selectedIndexesCount = this.left.getList().getSelectedIndices().length;
        boolean moveEnabled = selectedIndexesCount > 0;
        this.btnMoveRight.setEnabled(moveEnabled);
    }

    protected void checkRightListSelection() {
        int selectedIndexesCount = this.right.getList().getSelectedIndices().length;
        boolean moveEnabled = selectedIndexesCount > 0;
        this.btnMoveLeft.setEnabled(moveEnabled);
    }

    public JListPanel<E> getLeftListPanel() {
        return this.left;
    }

    public JListPanel<E> getRightListPanel() {
        return this.right;
    }
}

