/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.gc4s.input;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.util.List;
import java.util.function.Function;
import javax.swing.JPanel;
import org.sing_group.gc4s.dialog.AbstractInputJDialog;
import org.sing_group.gc4s.input.ItemSelectionPanel;

public class ItemSelectionDialog<T>
extends AbstractInputJDialog {
    private static final long serialVersionUID = 1L;
    private List<T> items;
    private int n;
    private JPanel inputComponentsPane;
    private ItemSelectionPanel<T> itemSelectionPanel;
    private Function<T, String> namingFunction;
    private boolean allowRepetitions;

    public ItemSelectionDialog(Window parent, List<T> items, int n) {
        this(parent, items, n, Object::toString, false);
    }

    public ItemSelectionDialog(Window parent, List<T> items, int n, Function<T, String> namingFunction, boolean allowRepetitions) {
        super(parent);
        this.items = items;
        this.n = n;
        this.namingFunction = namingFunction;
        this.allowRepetitions = allowRepetitions;
        this.init();
    }

    private void init() {
        this.inputComponentsPane.add(this.createItemSelectionPanel(), "Center");
    }

    private Component createItemSelectionPanel() {
        this.itemSelectionPanel = new ItemSelectionPanel<T>(this.items, this.n, this.namingFunction);
        this.itemSelectionPanel.addPropertyChangeListener("gc4s.item.selection", e -> this.checkOkButton());
        return this.itemSelectionPanel;
    }

    private void checkOkButton() {
        this.okButton.setEnabled(this.isValidSelection());
    }

    private boolean isValidSelection() {
        return this.allowRepetitions || !this.areRepeatedElementsSelected();
    }

    private boolean areRepeatedElementsSelected() {
        return this.getSelectedItems().stream().distinct().count() < (long)this.n;
    }

    @Override
    protected String getDialogTitle() {
        return "Item selection";
    }

    @Override
    protected String getDescription() {
        return "This dialog allows you to select items.";
    }

    @Override
    protected JPanel getInputComponentsPane() {
        this.inputComponentsPane = new JPanel(new BorderLayout());
        return this.inputComponentsPane;
    }

    public List<T> getSelectedItems() {
        return this.itemSelectionPanel.getSelectedItems();
    }

    @Override
    public void setVisible(boolean b) {
        this.checkOkButton();
        this.pack();
        super.setVisible(b);
    }
}

