/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.sql;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import weka.gui.sql.Messages;
import weka.gui.sql.SqlViewer;
import weka.gui.sql.event.ResultChangedEvent;
import weka.gui.sql.event.ResultChangedListener;

public class SqlViewerDialog
extends JDialog
implements ResultChangedListener {
    private static final long serialVersionUID = -31619864037233099L;
    protected JFrame m_Parent;
    protected SqlViewer m_Viewer;
    protected JPanel m_PanelButtons;
    protected JButton m_ButtonOK;
    protected JButton m_ButtonCancel;
    protected JLabel m_LabelQuery;
    protected int m_ReturnValue;
    protected String m_URL;
    protected String m_User;
    protected String m_Password;
    protected String m_Query;

    public SqlViewerDialog(JFrame parent) {
        Messages.getInstance();
        super(parent, Messages.getString("SqlViewerDialog_SQL_Viewer_Text"), true);
        Messages.getInstance();
        this.m_ButtonOK = new JButton(Messages.getString("SqlViewerDialog_ButtonOK_JButton_Text"));
        Messages.getInstance();
        this.m_ButtonCancel = new JButton(Messages.getString("SqlViewerDialog_ButtonCancel_JButton_Text"));
        this.m_LabelQuery = new JLabel("");
        this.m_ReturnValue = 2;
        this.m_Parent = parent;
        this.m_URL = "";
        this.m_User = "";
        this.m_Password = "";
        this.m_Query = "";
        this.createDialog();
    }

    protected void createDialog() {
        final SqlViewerDialog dialog = this;
        this.setLayout(new BorderLayout());
        this.m_Viewer = new SqlViewer(this.m_Parent);
        this.add((Component)this.m_Viewer, "Center");
        JPanel panel2 = new JPanel(new BorderLayout());
        this.add((Component)panel2, "South");
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout());
        panel2.add((Component)panel, "East");
        this.m_ButtonOK.setMnemonic('O');
        panel.add(this.m_ButtonOK);
        this.m_ButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SqlViewerDialog.this.m_ReturnValue = 0;
                SqlViewerDialog.this.m_Viewer.removeResultChangedListener(dialog);
                SqlViewerDialog.this.m_Viewer.saveSize();
                dialog.dispose();
            }
        });
        this.m_ButtonCancel.setMnemonic('C');
        panel.add(this.m_ButtonCancel);
        this.m_ButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SqlViewerDialog.this.m_ReturnValue = 2;
                SqlViewerDialog.this.m_Viewer.removeResultChangedListener(dialog);
                SqlViewerDialog.this.m_Viewer.saveSize();
                dialog.dispose();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                SqlViewerDialog.this.m_Viewer.saveSize();
            }
        });
        panel = new JPanel(new FlowLayout());
        panel2.add((Component)panel, "Center");
        panel.add(this.m_LabelQuery);
        this.pack();
        this.getRootPane().setDefaultButton(this.m_ButtonOK);
        this.setResizable(true);
        this.m_Viewer.addResultChangedListener(this);
    }

    public void setVisible(boolean b) {
        if (b) {
            this.m_ReturnValue = 2;
        }
        super.setVisible(b);
        if (b) {
            this.m_Viewer.clear();
        }
    }

    public int getReturnValue() {
        return this.m_ReturnValue;
    }

    public String getURL() {
        return this.m_URL;
    }

    public String getUser() {
        return this.m_User;
    }

    public String getPassword() {
        return this.m_Password;
    }

    public String getQuery() {
        return this.m_Query;
    }

    public void resultChanged(ResultChangedEvent evt) {
        this.m_URL = evt.getURL();
        this.m_User = evt.getUser();
        this.m_Password = evt.getPassword();
        this.m_Query = evt.getQuery();
        StringBuilder stringBuilder = new StringBuilder();
        Messages.getInstance();
        this.m_LabelQuery.setText(stringBuilder.append(Messages.getString("SqlViewerDialog_ResultChanged_Text")).append(this.m_Query).toString());
    }

    public static void main(String[] args) {
        SqlViewerDialog dialog = new SqlViewerDialog(null);
        dialog.setDefaultCloseOperation(2);
        dialog.setVisible(true);
        StringBuilder stringBuilder = new StringBuilder();
        Messages.getInstance();
        System.out.println(stringBuilder.append(Messages.getString("SqlViewerDialog_Main_Text_First")).append(dialog.getReturnValue()).toString());
        if (dialog.getReturnValue() == 0) {
            StringBuilder stringBuilder2 = new StringBuilder();
            Messages.getInstance();
            System.out.println(stringBuilder2.append(Messages.getString("SqlViewerDialog_Main_Text_Second")).append(dialog.getURL()).toString());
            StringBuilder stringBuilder3 = new StringBuilder();
            Messages.getInstance();
            System.out.println(stringBuilder3.append(Messages.getString("SqlViewerDialog_Main_Text_Third")).append(dialog.getUser()).toString());
            StringBuilder stringBuilder4 = new StringBuilder();
            Messages.getInstance();
            System.out.println(stringBuilder4.append(Messages.getString("SqlViewerDialog_Main_Text_Fourth")).append(dialog.getPassword().replaceAll(".", "*")).toString());
            StringBuilder stringBuilder5 = new StringBuilder();
            Messages.getInstance();
            System.out.println(stringBuilder5.append(Messages.getString("SqlViewerDialog_Main_Text_Fifth")).append(dialog.getQuery()).toString());
        }
    }
}

