/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.s2p.gui.samespots;

import es.uvigo.ei.sing.commons.csv.entities.CsvFormat;
import es.uvigo.ei.sing.s2p.core.entities.Sample;
import es.uvigo.ei.sing.s2p.core.io.samespots.SameSpotsCsvWriter;
import es.uvigo.ei.sing.s2p.gui.UISettings;
import es.uvigo.ei.sing.s2p.gui.components.dialog.ExportCsvDialog;
import es.uvigo.ei.sing.s2p.gui.samespots.ConditionLabelInputDialog;
import es.uvigo.ei.sing.s2p.gui.samespots.SampleEditorDialog;
import es.uvigo.ei.sing.s2p.gui.samespots.SampleMergeDialog;
import es.uvigo.ei.sing.s2p.gui.samples.SamplesComparisonTable;
import es.uvigo.ei.sing.s2p.gui.util.CsvUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;
import org.sing_group.gc4s.input.csv.CsvFormat;
import org.sing_group.gc4s.ui.icons.Icons;
import org.sing_group.gc4s.utilities.ExtendedAbstractAction;
import org.sing_group.gc4s.utilities.builder.JButtonBuilder;

public class SameSpotsDatasetViewer
extends JPanel {
    private static final long serialVersionUID = 1L;
    private List<Sample> samples;
    private List<String> conditionLabels = Collections.emptyList();
    private SamplesComparisonTable samplesTable;
    private JPanel northPanel;
    private JButton editConditionsBtn;
    private JButton editSamplesBtn;
    private JButton mergeSamplesBtn;
    private Map<Sample, String> sampleConditions;

    public SameSpotsDatasetViewer(List<Sample> samples) {
        this(samples, new HashMap<Sample, String>());
    }

    public SameSpotsDatasetViewer(List<Sample> samples, Map<Sample, String> sampleConditions) {
        this.samples = samples;
        this.sampleConditions = sampleConditions;
        this.conditionLabels = new LinkedList<String>(this.sampleConditions.values());
        this.initComponent();
    }

    private void initComponent() {
        this.setLayout(new BorderLayout());
        this.setBackground(UISettings.BG_COLOR);
        this.add(this.getNorthPanel(), "North");
        this.add(this.getSamplesTable(), "Center");
    }

    private Component getNorthPanel() {
        if (this.northPanel == null) {
            this.northPanel = new JPanel();
            this.northPanel.setLayout(new BoxLayout(this.northPanel, 0));
            this.northPanel.setOpaque(false);
            this.northPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
            this.northPanel.add(this.getEditConditionsButton());
            this.northPanel.add(this.getEditSamplesButton());
            this.northPanel.add(this.getMergeSamplesButton());
            this.northPanel.add(Box.createHorizontalGlue());
            this.northPanel.add(this.getExportToCsvButton());
        }
        return this.northPanel;
    }

    private JButton getEditConditionsButton() {
        if (this.editConditionsBtn == null) {
            this.editConditionsBtn = JButtonBuilder.newJButtonBuilder().withTooltip("Edit experiment's conditions.").thatDoes(this.getEditConditionsAction()).build();
        }
        return this.editConditionsBtn;
    }

    private Action getEditConditionsAction() {
        return new ExtendedAbstractAction("Conditions", (Icon)Icons.ICON_EDIT_16, this::editConditions);
    }

    private JButton getEditSamplesButton() {
        if (this.editSamplesBtn == null) {
            this.editSamplesBtn = JButtonBuilder.newJButtonBuilder().withTooltip("Edit experiment's samples.").thatDoes(this.getEditSamplesAction()).build();
            this.editSamplesBtn.setEnabled(!this.conditionLabels.isEmpty());
        }
        return this.editSamplesBtn;
    }

    private Action getEditSamplesAction() {
        return new ExtendedAbstractAction("Samples", (Icon)Icons.ICON_EDIT_16, this::editSamples);
    }

    private JButton getMergeSamplesButton() {
        if (this.mergeSamplesBtn == null) {
            this.mergeSamplesBtn = JButtonBuilder.newJButtonBuilder().withTooltip("Merge experiment's samples.").thatDoes(this.getMergeSamplesAction()).build();
        }
        return this.mergeSamplesBtn;
    }

    private Action getMergeSamplesAction() {
        return new ExtendedAbstractAction("Merge", (Icon)Icons.ICON_MERGE_16, this::mergeSamples);
    }

    private JButton getExportToCsvButton() {
        return JButtonBuilder.newJButtonBuilder().withTooltip("Export into a .CSV file").thatDoes(this.getExportToCsvAction()).build();
    }

    private Action getExportToCsvAction() {
        return new ExtendedAbstractAction("Export to CSV", (Icon)Icons.ICON_EXPORT_16, this::exportToCsv);
    }

    private Component getSamplesTable() {
        if (this.samplesTable == null) {
            this.samplesTable = new SamplesComparisonTable(this.samples, true);
            this.samplesTable.setShowComponentPopupMenu(true);
            this.samplesTable.setOpaque(false);
            this.samplesTable.getTableHeader().setReorderingAllowed(true);
            this.samplesTable.getTableHeader().addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    SameSpotsDatasetViewer.this.checkColumnsOrder();
                }
            });
            this.samplesTable.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        }
        return this.samplesTable;
    }

    protected synchronized void checkColumnsOrder() {
        Enumeration<TableColumn> columns = this.samplesTable.getTableHeader().getColumnModel().getColumns();
        final HashMap<String, Integer> sampleNameToIndex = new HashMap<String, Integer>();
        int i = 0;
        while (columns.hasMoreElements()) {
            sampleNameToIndex.put(columns.nextElement().getHeaderValue().toString(), i++);
        }
        this.samples.sort(new Comparator<Sample>(){

            @Override
            public int compare(Sample o1, Sample o2) {
                return ((Integer)sampleNameToIndex.get(o1.getName())).compareTo((Integer)sampleNameToIndex.get(o2.getName()));
            }
        });
    }

    private void editConditions() {
        ConditionLabelInputDialog inputDialog = new ConditionLabelInputDialog(this.getDialogParent(), this.conditionLabels);
        inputDialog.setVisible(true);
        if (!inputDialog.isCanceled()) {
            this.conditionLabels = inputDialog.getConditionLabels();
            this.getEditSamplesButton().setEnabled(!this.conditionLabels.isEmpty());
        }
    }

    private Window getDialogParent() {
        return SwingUtilities.getWindowAncestor(this);
    }

    private void editSamples() {
        SampleEditorDialog editor = new SampleEditorDialog(this.getDialogParent(), this.samples, this.conditionLabels, this.sampleConditions);
        editor.setVisible(true);
        if (!editor.isCanceled()) {
            this.sampleConditions = editor.getSampleConditions();
            this.updateSampleNames(editor.getSampleNames());
        }
    }

    private void updateSampleNames(Map<Sample, String> names) {
        names.keySet().forEach(sample -> {
            String newName = (String)names.get(sample);
            sample.setName(newName);
        });
        this.samplesTable.fireTableStructureChanged();
    }

    private void mergeSamples() {
        SampleMergeDialog merger = new SampleMergeDialog(this.getDialogParent(), this.samples);
        merger.setVisible(true);
        if (!merger.isCanceled()) {
            this.mergeSamples(merger.getSelectedItems());
        }
    }

    private void mergeSamples(List<Sample> toMerge) {
        if (toMerge.isEmpty()) {
            return;
        }
        Sample mergedSample = this.mergedSample(toMerge);
        int firstSampleIndex = this.samples.indexOf(toMerge.get(0));
        this.samples.removeAll(toMerge);
        this.samples.add(firstSampleIndex, mergedSample);
        this.samplesTable.fireTableStructureChanged();
    }

    private String mergedSampleName(List<Sample> toMerge) {
        return toMerge.stream().map(Sample::getName).collect(Collectors.joining("+"));
    }

    public Sample mergedSample(List<Sample> toMerge) {
        return new Sample(this.mergedSampleName(toMerge), this.mergedSpotValues(toMerge));
    }

    private Map<String, Double> mergedSpotValues(List<Sample> toMerge) {
        HashMap<String, Double> spotValues = new HashMap<String, Double>();
        toMerge.stream().map(Sample::getSpotValues).forEach(spotValues::putAll);
        return spotValues;
    }

    private void exportToCsv() {
        ExportCsvDialog exportCsv = new ExportCsvDialog(this.getDialogParent());
        exportCsv.setSelectedCsvFileFormat(CsvFormat.FileFormat.CUSTOM);
        exportCsv.setVisible(true);
        if (!exportCsv.isCanceled()) {
            try {
                this.exportToCsv(exportCsv.getSelectedFile(), CsvUtils.csvFormat(exportCsv.getSelectedCsvFormat()));
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(null, "There was an error while saving data into " + exportCsv.getSelectedFile(), "Error", 0);
            }
        }
    }

    protected void exportToCsv(File file, CsvFormat csvFormat) throws IOException {
        SameSpotsCsvWriter.write((File)file, this.samples, (CsvFormat)csvFormat, this.sampleConditions);
    }
}

