/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.s2p.core.operations.quantification;

import es.uvigo.ei.sing.s2p.core.entities.quantification.QuantificationReplicate;
import es.uvigo.ei.sing.s2p.core.entities.quantification.QuantificationSample;
import es.uvigo.ei.sing.s2p.core.operations.quantification.NormalizationFactor;
import es.uvigo.ei.sing.s2p.core.operations.quantification.NormalizationStrategy;
import es.uvigo.ei.sing.s2p.core.operations.quantification.NormalizationUtils;
import java.util.List;
import java.util.stream.Collectors;

public class ReplicateNormalizationStrategy
implements NormalizationStrategy {
    @Override
    public List<QuantificationSample> normalize(List<QuantificationSample> samples, NormalizationFactor factor) {
        return samples.stream().map(s -> ReplicateNormalizationStrategy.normalizeSample(s, factor)).collect(Collectors.toList());
    }

    private static final QuantificationSample normalizeSample(QuantificationSample sample, NormalizationFactor factor) {
        if (sample.getCondition().isPresent()) {
            return new QuantificationSample(sample.getName(), sample.getCondition().get(), sample.getReplicates().stream().map(r -> ReplicateNormalizationStrategy.normalize(r, factor)).collect(Collectors.toList()), sample.getProteinMass());
        }
        return new QuantificationSample(sample.getName(), sample.getReplicates().stream().map(r -> ReplicateNormalizationStrategy.normalize(r, factor)).collect(Collectors.toList()), sample.getProteinMass());
    }

    private static final QuantificationReplicate normalize(QuantificationReplicate replicate, NormalizationFactor factor) {
        double totalProteinValue = factor.getNormalizationFactor(NormalizationUtils.getProteinValues(replicate));
        return NormalizationUtils.normalizeReplicate(replicate, totalProteinValue);
    }
}

