/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.vda.core;

import es.uvigo.ei.sing.vda.core.RColors;
import es.uvigo.ei.sing.vda.core.VennDiagramCreator;
import es.uvigo.ei.sing.vda.core.entities.NamedRSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RLibraryVennDiagramCreator
implements VennDiagramCreator {
    private static final Collector<CharSequence, ?, String> JOINING = Collectors.joining(", ");
    private static final Map<String, String> DEFAULT_PARAMETERS = new HashMap<String, String>();

    static {
        DEFAULT_PARAMETERS.put("property.output-file", "venn-diagram.tiff");
    }

    @Override
    public String getRCode(List<NamedRSet<String>> sets) {
        return this.getRCode(sets, DEFAULT_PARAMETERS);
    }

    @Override
    public String getRCode(List<NamedRSet<String>> sets, Map<String, String> parameters) {
        StringBuilder sb = new StringBuilder();
        sets.forEach(sI -> {
            StringBuilder stringBuilder2 = sb.append(String.valueOf(sI.getRCode()) + "\n");
        });
        sb.append("\nlibrary(VennDiagram)\n\n").append("filename <- \"").append(parameters.get("property.output-file")).append("\"\n\n").append("venn.diagram(\n\tx=list(").append(RLibraryVennDiagramCreator.getSetsRNames(sets).map(s -> s.concat("=" + s)).collect(JOINING)).append(")").append(",\n\tfilename=filename").append(",\n\tfill = ").append(RColors.colorList(RLibraryVennDiagramCreator.getSetsRColors(sets))).append("\n)\n");
        return sb.toString();
    }

    private static Stream<String> getSetsRNames(List<NamedRSet<String>> sets) {
        return sets.stream().map(NamedRSet::getRSetName);
    }

    private static List<String> getSetsRColors(List<NamedRSet<String>> sets) {
        return sets.stream().map(NamedRSet::getRSetColor).collect(Collectors.toList());
    }

    @Override
    public String getDescription() {
        return "VennDiagram";
    }

    public String toString() {
        return this.getDescription();
    }
}

