/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.jsparklines_factory.builders.barchartrenderer;

import java.awt.Color;
import javax.swing.JTable;
import no.uib.jsparklines.renderers.JSparklinesBarChartTableCellRenderer;
import org.jfree.chart.plot.PlotOrientation;
import org.sing_group.jsparklines_factory.JSparklinesBarChartTableCellRendererFactory;
import org.sing_group.jsparklines_factory.util.TableUtils;

public class MaximumXYDataSignificanceBarChartRendererBuilder {
    private JTable table;
    private int column;
    private PlotOrientation plotOrientation = JSparklinesBarChartTableCellRendererFactory.DEFAULT_ORIENTATION;
    private Double maxValue;
    private Color positiveValuesColor = JSparklinesBarChartTableCellRendererFactory.DEFAULT_POSITIVES_COLOR;
    private Color nonSignificantValuesColor = JSparklinesBarChartTableCellRendererFactory.DEFAULT_NON_SIGNIFICANT_COLOR;
    private Double significanceLevel = 0.05;

    public MaximumXYDataSignificanceBarChartRendererBuilder(JTable table, int column) {
        this.table = table;
        this.column = column;
    }

    public MaximumXYDataSignificanceBarChartRendererBuilder withPlotOrientation(PlotOrientation plotOrientation) {
        this.plotOrientation = plotOrientation;
        return this;
    }

    public MaximumXYDataSignificanceBarChartRendererBuilder withMaxValue(Double maxValue) {
        this.maxValue = maxValue;
        return this;
    }

    public MaximumXYDataSignificanceBarChartRendererBuilder withPositiveValuesColor(Color positiveValuesColor) {
        this.positiveValuesColor = positiveValuesColor;
        return this;
    }

    public MaximumXYDataSignificanceBarChartRendererBuilder withNonSignificanteValuesColor(Color nonSignificantValuesColor) {
        this.nonSignificantValuesColor = nonSignificantValuesColor;
        return this;
    }

    public MaximumXYDataSignificanceBarChartRendererBuilder withSignificanceLevel(Double significanceLevel) {
        this.significanceLevel = significanceLevel;
        return this;
    }

    public JSparklinesBarChartTableCellRenderer build() {
        this.checkMaxValue();
        return JSparklinesBarChartTableCellRendererFactory.createMaxXYDataSignificanceBarChartRenderer(this.table, this.column, this.plotOrientation, this.maxValue, this.positiveValuesColor, this.nonSignificantValuesColor, this.significanceLevel);
    }

    private void checkMaxValue() {
        if (this.maxValue == null) {
            this.maxValue = TableUtils.getMaxColumnValue(this.table, this.column);
        }
    }
}

