/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.s2p.core.entities.quantification;

import es.uvigo.ei.sing.s2p.core.util.ArrayUtils;
import java.util.List;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;

public class ProteinSummary {
    private int numReplicates;
    private int totalReplicates;
    private List<Double> proteinValues;
    private DescriptiveStatistics proteinValuesStatistics;
    private List<Double> normalizedProteinValues;
    private DescriptiveStatistics normalizedProteinValuesStatistics;
    private List<Double> proteinMassValues;
    private DescriptiveStatistics proteinMassValuesStatistics;

    public ProteinSummary(int totalReplicates, List<Double> proteinValues, List<Double> proteinNormalizedValues, List<Double> proteinMassValues) {
        this.totalReplicates = totalReplicates;
        this.proteinValuesStatistics = new DescriptiveStatistics(ArrayUtils.doubleArray(proteinValues));
        this.normalizedProteinValuesStatistics = new DescriptiveStatistics(ArrayUtils.doubleArray(proteinNormalizedValues));
        this.proteinMassValuesStatistics = new DescriptiveStatistics(ArrayUtils.doubleArray(proteinMassValues));
        this.numReplicates = (int)this.proteinValuesStatistics.getN();
        this.proteinValues = proteinValues;
        this.normalizedProteinValues = proteinNormalizedValues;
        this.proteinMassValues = proteinMassValues;
    }

    public int getNumReplicates() {
        return this.numReplicates;
    }

    public int getTotalReplicates() {
        return this.totalReplicates;
    }

    public double getProteinValueMean() {
        return this.proteinValuesStatistics.getMean();
    }

    public double getProteinValueStd() {
        return this.proteinValuesStatistics.getStandardDeviation();
    }

    public double getProteinValueRsd() {
        return this.getProteinValueStd() / this.getProteinValueMean();
    }

    public double getNormalizedProteinValueMean() {
        return this.normalizedProteinValuesStatistics.getMean();
    }

    public double getNormalizedProteinValueStd() {
        return this.normalizedProteinValuesStatistics.getStandardDeviation();
    }

    public double getNormalizedProteinValueRsd() {
        return this.getNormalizedProteinValueStd() / this.getNormalizedProteinValueMean();
    }

    public double getProteinMassValueMean() {
        return this.proteinMassValuesStatistics.getMean();
    }

    public double getProteinMassValueStd() {
        return this.proteinMassValuesStatistics.getStandardDeviation();
    }

    public double getProteinMassValueRsd() {
        return this.getProteinMassValueStd() / this.getProteinMassValueMean();
    }

    public double getPop() {
        return 100.0 * (double)this.getNumReplicates() / (double)this.getTotalReplicates();
    }

    public List<Double> getProteinValues() {
        return this.proteinValues;
    }

    public List<Double> getNormalizedProteinValues() {
        return this.normalizedProteinValues;
    }

    public List<Double> getProteinMassValues() {
        return this.proteinMassValues;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[SpotSummary] Total = ").append(this.getTotalReplicates()).append(" | Spots = ").append(this.getNumReplicates()).append(" | POP = ").append(this.getPop());
        return sb.toString();
    }
}

