/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.s2p.gui.mascot;

import es.uvigo.ei.sing.s2p.core.entities.MascotEntry;
import es.uvigo.ei.sing.s2p.core.entities.SpotMascotIdentifications;
import es.uvigo.ei.sing.s2p.core.io.samespots.SameSpotsReportFileWriter;
import es.uvigo.ei.sing.s2p.core.io.samespots.SameSpotsReportFileWriterConfiguration;
import es.uvigo.ei.sing.s2p.gui.mascot.SpotMascotIdentificationsTableModel;
import es.uvigo.ei.sing.s2p.gui.samespots.FillSameSpotsReportDialog;
import es.uvigo.ei.sing.s2p.gui.table.ExtendedCsvTable;
import java.awt.Component;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.stream.IntStream;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.renderer.DefaultTableRenderer;
import org.sing_group.gc4s.event.PopupMenuAdapter;
import org.sing_group.gc4s.table.ColumnSummaryTabeCellRenderer;
import org.sing_group.gc4s.utilities.ExtendedAbstractAction;
import org.sing_group.jsparklines_factory.JSparklinesBarChartTableCellRendererFactory;

public class SpotMascotIdentificationsTable
extends ExtendedCsvTable {
    private static final long serialVersionUID = 1L;
    private ExtendedAbstractAction fillSameSpotsReportAction;
    private ExtendedAbstractAction removeSpotsAction;
    private SpotMascotIdentifications spotIdentifications;

    public SpotMascotIdentificationsTable(SpotMascotIdentifications spotIdentifications) {
        this(spotIdentifications.getSpots(), spotIdentifications);
    }

    public SpotMascotIdentificationsTable(Set<String> spots, SpotMascotIdentifications spotIdentifications) {
        super(SpotMascotIdentificationsTable.createModel(spots, spotIdentifications));
        this.spotIdentifications = spotIdentifications;
        this.initComponent();
    }

    private static TableModel createModel(Set<String> spots, SpotMascotIdentifications identifications) {
        return new SpotMascotIdentificationsTableModel(spots, identifications);
    }

    private void initComponent() {
        this.setColumVisibilityActionsEnabled(false);
        this.setAutoCreateRowSorter(true);
        this.setColumnControlVisible(true);
        this.getRowSorter().toggleSortOrder(3);
        this.getRowSorter().toggleSortOrder(3);
        this.addExportToCsvAction();
        this.addFillReportaction();
        this.getTableHeader().setReorderingAllowed(false);
        this.getTableHeader().setDefaultRenderer((TableCellRenderer)new ColumnSummaryTabeCellRenderer(this.getTableHeader().getDefaultRenderer()));
        this.setDefaultRenderer(File.class, (TableCellRenderer)((Object)new FileCellRenderer()));
        this.setComponentPopupMenu(this.getTablePopupMenu());
        this.updateSparklinesRenderers();
        this.getSpotsTableModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                SpotMascotIdentificationsTable.this.updateSparklinesRenderers();
            }
        });
        this.updateUI();
    }

    private void updateSparklinesRenderers() {
        for (int i : Arrays.asList(3, 4, 5, 6, 8)) {
            JSparklinesBarChartTableCellRendererFactory.createMaxValueBarChartRenderer((JTable)((Object)this), (int)i).showNumberAndChart(true, 40);
        }
    }

    private void addFillReportaction() {
        this.addAction(this.getFillSameSpotsReportButton());
    }

    private Action getFillSameSpotsReportButton() {
        if (this.fillSameSpotsReportAction == null) {
            this.fillSameSpotsReportAction = new ExtendedAbstractAction("Fill SameSpots report", this::fillSameSpotsReport);
        }
        return this.fillSameSpotsReportAction;
    }

    private void fillSameSpotsReport() {
        FillSameSpotsReportDialog dialog = new FillSameSpotsReportDialog(this.getDialogParent());
        dialog.setVisible(true);
        if (!dialog.isCanceled()) {
            this.fillSameSpotsReport(dialog.getSelectedFile(), dialog.getSelectedConfiguration());
        }
    }

    private Window getDialogParent() {
        return SwingUtilities.getWindowAncestor((Component)((Object)this));
    }

    private void fillSameSpotsReport(File reportDirectory, SameSpotsReportFileWriterConfiguration configuration) {
        try {
            SameSpotsReportFileWriter.writeReportDirectory((SpotMascotIdentifications)this.spotIdentifications, (File)reportDirectory, (SameSpotsReportFileWriterConfiguration)configuration);
            JOptionPane.showMessageDialog((Component)((Object)this), "Reports at " + reportDirectory + " has been successfully processed", "Success", 1);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog((Component)((Object)this), "An error ocurred writing report files", "Error", 0);
        }
    }

    private JPopupMenu getTablePopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        menu.add(this.getRemoveSelectedRowsAction());
        menu.addPopupMenuListener((PopupMenuListener)new PopupMenuAdapter(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                SpotMascotIdentificationsTable.this.removeSpotsAction.setEnabled(SpotMascotIdentificationsTable.this.getSelectedRowCount() > 0);
            }
        });
        return menu;
    }

    private Action getRemoveSelectedRowsAction() {
        this.removeSpotsAction = new ExtendedAbstractAction("Remove selected spots", this::removeSelectedSpots);
        this.removeSpotsAction.setEnabled(false);
        return this.removeSpotsAction;
    }

    private void removeSelectedSpots() {
        if (this.getSelectedRowCount() > 0) {
            this.removeSelectedSpotsFromSamples();
            this.getSpotsTableModel().fireTableDataChanged();
        }
    }

    private SpotMascotIdentificationsTableModel getSpotsTableModel() {
        return (SpotMascotIdentificationsTableModel)this.getModel();
    }

    private void removeSelectedSpotsFromSamples() {
        IntStream.of(this.getSelectedRows()).boxed().map(arg_0 -> this.convertRowIndexToModel(arg_0)).sorted(Collections.reverseOrder(Integer::compareTo)).forEach(i -> this.removeSpotFromSamples((int)i));
    }

    private void removeSpotFromSamples(int row) {
        SpotMascotIdentificationsTableModel model = this.getSpotsTableModel();
        String spot = model.getSpotAtRow(row);
        MascotEntry entry = model.getMascotEntryAtRow(row);
        this.spotIdentifications.removeIdentification(spot, entry);
    }

    private class FileCellRenderer
    extends DefaultTableRenderer {
        private static final long serialVersionUID = 1L;

        private FileCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (c instanceof JLabel && value instanceof File) {
                JLabel label = (JLabel)c;
                label.setText(((File)value).getName());
                label.setToolTipText(((File)value).getAbsolutePath());
            }
            return c;
        }
    }
}

