/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.gc4s.input;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ItemEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;
import org.sing_group.gc4s.combobox.ComboBoxItem;
import org.sing_group.gc4s.input.InputParameter;
import org.sing_group.gc4s.input.InputParametersPanel;
import org.sing_group.gc4s.utilities.FontUtils;

public class FontConfigurationPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final String SELECTED_FONT = "gc4s.fontconfig.selection";
    private Font oldValue;
    private JSpinner fontSize;
    private JScrollPane previewFontPanel;
    private JComboBox<FontStyle> fontStylesCmb;
    private JComboBox<ComboBoxItem<Font>> fontsCmb;
    private JTextArea sampleText = new JTextArea("Sample text");
    private Map<String, ComboBoxItem<Font>> fontsMap = new HashMap<String, ComboBoxItem<Font>>();

    public FontConfigurationPanel() {
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.add((Component)new InputParametersPanel(this.getParameters()), "Center");
        this.add((Component)this.getPreviewFontPanel(), "South");
        this.updateFontPreview();
    }

    private InputParameter[] getParameters() {
        InputParameter[] parameters = new InputParameter[]{this.getFontParameter(), this.getFontSizeParameter(), this.getFontStyleParameter()};
        return parameters;
    }

    private InputParameter getFontParameter() {
        this.fontsCmb = new JComboBox();
        this.getFontItems().forEach(this.fontsCmb::addItem);
        this.fontsCmb.addItemListener(this::comboItemChanged);
        return new InputParameter("Font type", this.fontsCmb, "The font type.");
    }

    private void comboItemChanged(ItemEvent event) {
        if (event.getStateChange() == 1) {
            this.notifySelectedFontPropertyChange();
            this.updateFontPreview();
        }
    }

    private List<ComboBoxItem<Font>> getFontItems() {
        return Stream.of(FontUtils.getAvailableFonts()).map(f -> new ComboBoxItem<Font>((Font)f, f.getName())).peek(i -> this.fontsMap.put(i.toString(), (ComboBoxItem<Font>)i)).collect(Collectors.toList());
    }

    private InputParameter getFontSizeParameter() {
        this.fontSize = new JSpinner(new SpinnerNumberModel(12, 1, 128, 1));
        this.fontSize.addChangeListener(e -> this.fontSizeChanged());
        return new InputParameter("Font size", this.fontSize, "The font size.");
    }

    private InputParameter getFontStyleParameter() {
        this.fontStylesCmb = new JComboBox<FontStyle>(FontStyle.values());
        this.fontStylesCmb.addItemListener(this::comboItemChanged);
        return new InputParameter("Font style", this.fontStylesCmb, "The font style.");
    }

    private void fontSizeChanged() {
        this.notifySelectedFontPropertyChange();
        this.updateFontPreview();
    }

    private void notifySelectedFontPropertyChange() {
        this.firePropertyChange(SELECTED_FONT, this.oldValue, this.getSelectedFont());
    }

    private void updateFontPreview() {
        this.oldValue = this.getSelectedFont();
        this.sampleText.setFont(this.oldValue);
    }

    private JComponent getPreviewFontPanel() {
        this.previewFontPanel = new JScrollPane();
        this.previewFontPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLoweredBevelBorder(), "Font preview"));
        this.previewFontPanel.setViewportView(this.sampleText);
        this.sampleText.setMinimumSize(new Dimension(100, 100));
        this.sampleText.setPreferredSize(new Dimension(100, 100));
        this.sampleText.setEditable(false);
        return this.previewFontPanel;
    }

    public void setFontPreviewVisible(boolean visible) {
        this.previewFontPanel.setVisible(visible);
    }

    public Font getSelectedFont() {
        ComboBoxItem selectedItem = (ComboBoxItem)this.fontsCmb.getSelectedItem();
        Font selected = (Font)selectedItem.getItem();
        return selected.deriveFont(this.getFontStyle(), this.getFontSize());
    }

    private int getFontStyle() {
        return ((FontStyle)((Object)this.fontStylesCmb.getSelectedItem())).getStyle();
    }

    private float getFontSize() {
        return ((Integer)this.fontSize.getValue()).floatValue();
    }

    public void setSelectedFont(Font font) {
        if (this.fontsMap.containsKey(font.getName())) {
            this.fontsCmb.setSelectedItem(this.fontsMap.get(font.getName()));
            this.fontSize.setValue(font.getSize());
            this.fontStylesCmb.setSelectedItem((Object)FontStyle.getFontStyle(font.getStyle()));
        }
    }

    private static enum FontStyle {
        PLAIN("Normal", 0),
        BOLD("Bold", 1),
        ITALIC("Italic", 2),
        BOLD_ITALIC("Bold Italic", 3);

        private String description;
        private int font;

        private FontStyle(String description, int font) {
            this.description = description;
            this.font = font;
        }

        public String toString() {
            return this.description;
        }

        public int getStyle() {
            return this.font;
        }

        public static FontStyle getFontStyle(int fontStyle) {
            switch (fontStyle) {
                case 0: {
                    return PLAIN;
                }
                case 1: {
                    return BOLD;
                }
                case 2: {
                    return ITALIC;
                }
                case 3: {
                    return BOLD_ITALIC;
                }
            }
            throw new IllegalArgumentException("");
        }
    }
}

