/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.gc4s.filechooser;

import java.io.File;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.filechooser.FileFilter;

public class ExtensionFileFilter
extends FileFilter {
    public static final boolean DEFAULT_CASE_SENSITIVE = true;
    private final String nameregexp;
    private final String description;
    private boolean caseSensitive;

    public ExtensionFileFilter(String regex, String description) {
        this(regex, description, true);
    }

    public ExtensionFileFilter(String regex, String description, boolean caseSensitive) {
        this.nameregexp = this.requestValidRegex(regex);
        this.description = description;
        this.caseSensitive = caseSensitive;
    }

    private String requestValidRegex(String regex) {
        try {
            Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        return regex;
    }

    @Override
    public boolean accept(File pathname) {
        return pathname.isDirectory() || pathname.getName().matches(this.getRegex());
    }

    private String getRegex() {
        return this.caseSensitive ? this.nameregexp : "(?i)" + this.nameregexp;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public boolean equals(Object aThat) {
        if (aThat == null) {
            return false;
        }
        if (!(aThat instanceof ExtensionFileFilter)) {
            return false;
        }
        ExtensionFileFilter that = (ExtensionFileFilter)aThat;
        return this.nameregexp.equals(that.nameregexp) && this.description.equals(that.description) && this.caseSensitive == that.caseSensitive;
    }
}

