/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.s2p.gui.spots.comparison;

import es.uvigo.ei.sing.s2p.core.entities.Condition;
import es.uvigo.ei.sing.s2p.core.entities.Sample;
import es.uvigo.ei.sing.s2p.core.entities.SpotMascotIdentifications;
import es.uvigo.ei.sing.s2p.core.entities.SpotsData;
import es.uvigo.ei.sing.s2p.gui.UISettings;
import es.uvigo.ei.sing.s2p.gui.event.ProteinDataComparisonEvent;
import es.uvigo.ei.sing.s2p.gui.event.ProteinDataComparisonListener;
import es.uvigo.ei.sing.s2p.gui.spots.comparison.ProteinDataComparisonInformationPanel;
import es.uvigo.ei.sing.s2p.gui.spots.comparison.ProteinDataComparisonTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public class ConditionVsConditionComparisonView
extends JPanel
implements ProteinDataComparisonListener {
    private static final long serialVersionUID = 1L;
    private List<Condition> conditions;
    private JPanel northPane;
    private JPanel centerPane;
    private JComboBox<Object> condition1Cmb;
    private JComboBox<Object> condition2Cmb;
    private ProteinDataComparisonTable comparisonTable;
    private JPanel southPane;
    private ProteinDataComparisonInformationPanel comparisonInformationPanel;
    private JButton viewButton;
    private Sample[] sampleSelection;

    public ConditionVsConditionComparisonView(SpotsData data) {
        this.conditions = data.getConditions();
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.setBackground(UISettings.BG_COLOR);
        this.add((Component)this.getSplitPane(), "Center");
    }

    private JSplitPane getSplitPane() {
        JSplitPane splitPane = new JSplitPane(0);
        splitPane.setTopComponent(this.getTopComponent());
        splitPane.setBottomComponent(this.getBottomComponent());
        splitPane.setDividerLocation(250);
        splitPane.setOneTouchExpandable(true);
        return splitPane;
    }

    private Component getTopComponent() {
        JPanel topComponent = new JPanel(new BorderLayout());
        topComponent.add((Component)this.getNorthPane(), "North");
        topComponent.add((Component)this.getCenterPane(), "Center");
        return topComponent;
    }

    private JPanel getNorthPane() {
        if (this.northPane == null) {
            this.northPane = new JPanel(new FlowLayout());
            this.northPane.setBackground(UISettings.BG_COLOR);
            this.condition1Cmb = new JComboBox<Object>(this.getConditionsNames().toArray());
            this.condition2Cmb = new JComboBox<Object>(this.getConditionsNames().toArray());
            this.condition1Cmb.setSelectedIndex(0);
            this.condition2Cmb.setSelectedIndex(this.getConditionsNames().size() - 1);
            this.condition1Cmb.addItemListener(this::selectionChanged);
            this.condition2Cmb.addItemListener(this::selectionChanged);
            this.northPane.add(this.condition1Cmb);
            this.northPane.add(this.condition2Cmb);
            this.northPane.add(Box.createHorizontalGlue());
            this.northPane.add(this.getViewButton());
        }
        return this.northPane;
    }

    private Component getViewButton() {
        if (this.viewButton == null) {
            this.viewButton = new JButton("Compare samples");
            this.viewButton.setEnabled(false);
            this.viewButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    ConditionVsConditionComparisonView.this.onViewButtonClick();
                }
            });
        }
        return this.viewButton;
    }

    private void onViewButtonClick() {
        this.fireSampleSelectionEvent(new ProteinDataComparisonEvent(this.sampleSelection, ProteinDataComparisonEvent.Type.SAMPLE_SELECTION));
    }

    private void fireSampleSelectionEvent(ProteinDataComparisonEvent proteinDataComparisonTableEvent) {
        Arrays.asList(this.getTableListeners()).stream().forEach(l -> l.onSampleSelection(proteinDataComparisonTableEvent));
    }

    private void selectionChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            Condition condition1 = this.getCondition1();
            Condition condition2 = this.getCondition2();
            this.comparisonTable.setComparison(condition1, condition2);
            this.comparisonInformationPanel.setComparison(condition1, condition2);
        }
    }

    private Condition getCondition(int conditionIndex) {
        return this.conditions.get(conditionIndex);
    }

    public List<String> getConditionsNames() {
        return this.conditions.stream().map(Condition::getName).collect(Collectors.toList());
    }

    private JPanel getCenterPane() {
        if (this.centerPane == null) {
            this.centerPane = new JPanel(new BorderLayout());
            this.comparisonTable = new ProteinDataComparisonTable(this.conditions);
            this.comparisonTable.addTableListener(this);
            this.centerPane.add(this.comparisonTable);
        }
        return this.centerPane;
    }

    private Component getBottomComponent() {
        if (this.southPane == null) {
            this.southPane = new JPanel();
            this.southPane.setBackground(UISettings.BG_COLOR);
            Box box = new Box(1);
            box.add(Box.createHorizontalGlue());
            box.add(this.getProteinDataInformationPanel());
            box.add(Box.createHorizontalGlue());
            this.southPane.add(box);
        }
        return this.southPane;
    }

    private Component getProteinDataInformationPanel() {
        this.comparisonInformationPanel = new ProteinDataComparisonInformationPanel(this.getCondition1(), this.getCondition2());
        return this.comparisonInformationPanel;
    }

    private Condition getCondition1() {
        return this.getCondition(this.condition1Cmb.getSelectedIndex());
    }

    private Condition getCondition2() {
        return this.getCondition(this.condition2Cmb.getSelectedIndex());
    }

    @Override
    public void onSampleSelection(ProteinDataComparisonEvent event) {
        this.viewButton.setEnabled(true);
        this.sampleSelection = (Sample[])event.getSource();
    }

    @Override
    public void onSampleSelectionCleared(ProteinDataComparisonEvent event) {
        this.viewButton.setEnabled(false);
        this.sampleSelection = null;
    }

    public void addTableListener(ProteinDataComparisonListener l) {
        this.listenerList.add(ProteinDataComparisonListener.class, l);
    }

    public void removeTableListener(ProteinDataComparisonListener l) {
        this.listenerList.remove(ProteinDataComparisonListener.class, l);
    }

    public ProteinDataComparisonListener[] getTableListeners() {
        return (ProteinDataComparisonListener[])this.listenerList.getListeners(ProteinDataComparisonListener.class);
    }

    public void setMascotIdentifications(SpotMascotIdentifications identifications) {
        this.comparisonInformationPanel.setMascotIdentifications(identifications);
        this.comparisonTable.setMascotIdentifications(identifications);
    }

    public void setShowProteinIdentifications(boolean show) {
        this.comparisonInformationPanel.setShowProteinIdentifications(show);
        this.comparisonTable.setShowProteinIdentifications(show);
    }

    public void removeMascotIdentifications() {
        this.comparisonInformationPanel.removeMascotIdentifications();
        this.comparisonTable.removeMascotIdentifications();
    }
}

