/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.aibench.workbench.tablelayout;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TableLayout
extends JPanel {
    private static final String PROPERTY_SPLIT_LOCATION = "split location";
    private static final String PROPERTY_SPLIT_LOCATION_TYPE = "split location type";
    private static final long serialVersionUID = 1L;
    private Document doc;
    private final HashMap<String, Slot> idmappings = new HashMap();
    private final List<JSplitPane> splitPanes = new Vector<JSplitPane>();
    private JPanel documentViewer = null;
    private boolean hideTabs = false;

    public List<String> getAvailableSlots() {
        ArrayList<String> toret = new ArrayList<String>();
        for (String s : this.idmappings.keySet()) {
            toret.add(s);
        }
        return toret;
    }

    public Slot getSlotByID(String id) {
        return this.idmappings.get(id);
    }

    public boolean isHideTabs() {
        return this.hideTabs;
    }

    public void setHideTabs(boolean hideTabs) {
        this.hideTabs = hideTabs;
    }

    public JPanel getDocumentViewerPanel() {
        return this.documentViewer;
    }

    public TableLayout(InputStream stream) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        String allFile = "";
        String line = "";
        try {
            while ((line = reader.readLine()) != null) {
                allFile = allFile + line;
            }
            this.init(allFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void init(String xml_description) {
        xml_description = xml_description.replaceAll(">[^<>]*<", "><");
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringElementContentWhitespace(true);
        factory.setIgnoringComments(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.doc = builder.parse(new ByteArrayInputStream(xml_description.getBytes()));
            this.setLayout(new BorderLayout());
            this.parseTableElement(this.doc.getChildNodes().item(0), this);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void parseTableElement(Node n, JPanel panel) {
        this.parseRowSet(n.getChildNodes(), 0, panel, this.heightSizingType(n.getChildNodes()));
    }

    private Number getNodeHeight(Node node) {
        Node attribute = node.getAttributes().getNamedItem("height");
        if (attribute == null) {
            return null;
        }
        String height = attribute.getNodeValue();
        try {
            if (height.endsWith("%")) {
                return Double.parseDouble(height.substring(0, height.length() - 1)) / 100.0;
            }
            return Integer.parseInt(height);
        }
        catch (NumberFormatException nfe) {
            nfe.printStackTrace();
            return null;
        }
    }

    private Number getNodeWidth(Node node) {
        Node attribute = node.getAttributes().getNamedItem("width");
        if (attribute == null) {
            return null;
        }
        String width = attribute.getNodeValue();
        try {
            if (width.endsWith("%")) {
                return Double.parseDouble(width.substring(0, width.length() - 1)) / 100.0;
            }
            return Integer.parseInt(width);
        }
        catch (NumberFormatException nfe) {
            nfe.printStackTrace();
            return null;
        }
    }

    private SplitLocationType widthSizingType(NodeList list) {
        if (list.getLength() == 0) {
            return null;
        }
        Number firstWidth = this.getNodeWidth(list.item(0));
        boolean percentage = firstWidth instanceof Double;
        boolean absolute = firstWidth instanceof Integer;
        for (int i = 1; i < list.getLength(); ++i) {
            Number width = this.getNodeWidth(list.item(i));
            if (percentage && !(width instanceof Double)) {
                return null;
            }
            if (width instanceof Double) {
                percentage = true;
            } else if (width instanceof Integer) {
                absolute = true;
            }
            if (!percentage || !absolute) continue;
            return null;
        }
        if (percentage == absolute) {
            return null;
        }
        return percentage ? SplitLocationType.PERCENTAGE : SplitLocationType.ABSOLUTE;
    }

    private SplitLocationType heightSizingType(NodeList list) {
        if (list.getLength() == 0) {
            return null;
        }
        Number firstHeight = this.getNodeHeight(list.item(0));
        boolean percentage = firstHeight instanceof Double;
        boolean absolute = firstHeight instanceof Integer;
        for (int i = 1; i < list.getLength(); ++i) {
            Number height = this.getNodeHeight(list.item(i));
            if (percentage && !(height instanceof Double)) {
                return null;
            }
            if (height instanceof Double) {
                percentage = true;
            } else if (height instanceof Integer) {
                absolute = true;
            }
            if (!percentage || !absolute) continue;
            return null;
        }
        if (percentage == absolute) {
            return null;
        }
        return percentage ? SplitLocationType.PERCENTAGE : SplitLocationType.ABSOLUTE;
    }

    public void packSplitters() {
        for (JSplitPane pane : this.splitPanes) {
            Object propLocation = pane.getClientProperty(PROPERTY_SPLIT_LOCATION);
            Object propType = pane.getClientProperty(PROPERTY_SPLIT_LOCATION_TYPE);
            if (!(propLocation instanceof Number) || !(propType instanceof SplitLocationType)) continue;
            SplitLocationType type = (SplitLocationType)((Object)propType);
            if (type == SplitLocationType.ABSOLUTE) {
                pane.setDividerLocation(((Number)propLocation).intValue() + pane.getInsets().left);
            } else if (type == SplitLocationType.PERCENTAGE) {
                pane.setDividerLocation(((Number)propLocation).doubleValue());
            } else if (type == SplitLocationType.HEIGHT_RELATIVE) {
                pane.setDividerLocation(pane.getHeight() - pane.getInsets().bottom - pane.getDividerSize() - ((Number)propLocation).intValue());
            } else if (type == SplitLocationType.WIDTH_RELATIVE) {
                pane.setDividerLocation(pane.getSize().width - pane.getInsets().right - pane.getDividerSize() - ((Number)propLocation).intValue());
            }
            double location = pane.getOrientation() == 1 ? (double)pane.getDividerLocation() / (double)(pane.getWidth() - pane.getInsets().left - pane.getInsets().right) : (double)pane.getDividerLocation() / (double)(pane.getHeight() - pane.getInsets().top - pane.getInsets().bottom);
            pane.setResizeWeight(location);
            pane.repaint();
        }
    }

    private void parseRowSet(NodeList childNodes, int offset, JPanel panel, SplitLocationType sizing) {
        if (offset == childNodes.getLength()) {
            return;
        }
        if (childNodes.item(offset).getNodeType() == 3) {
            this.parseRowSet(childNodes, offset + 1, panel, sizing);
        } else if (offset < childNodes.getLength() - 1) {
            Node attrOneTouchExpandable = childNodes.item(offset).getAttributes().getNamedItem("oneTouchExpandable");
            boolean oneTouchExpandable = attrOneTouchExpandable == null || Boolean.valueOf(attrOneTouchExpandable.getTextContent()) != false;
            JSplitPane splitter = new JSplitPane();
            this.splitPanes.add(splitter);
            splitter.setResizeWeight(((double)childNodes.getLength() - (double)offset - 1.0) / (double)childNodes.getLength());
            splitter.setOrientation(0);
            splitter.setOneTouchExpandable(oneTouchExpandable);
            JPanel top = new JPanel();
            top.setLayout(new BorderLayout());
            splitter.setTopComponent(top);
            panel.add((Component)splitter, "Center");
            this.parseRow(childNodes.item(offset), top);
            JPanel bottom = new JPanel();
            bottom.setLayout(new BorderLayout());
            this.parseRowSet(childNodes, offset + 1, bottom, sizing);
            splitter.setBottomComponent(bottom);
            if (sizing != null) {
                if (sizing == SplitLocationType.ABSOLUTE) {
                    Number height = this.getNodeHeight(childNodes.item(offset));
                    if (height != null) {
                        splitter.putClientProperty(PROPERTY_SPLIT_LOCATION, height);
                        splitter.putClientProperty(PROPERTY_SPLIT_LOCATION_TYPE, (Object)sizing);
                    } else if (offset == childNodes.getLength() - 2 && (height = this.getNodeHeight(childNodes.item(offset + 1))) != null) {
                        splitter.putClientProperty(PROPERTY_SPLIT_LOCATION, height);
                        splitter.putClientProperty(PROPERTY_SPLIT_LOCATION_TYPE, (Object)SplitLocationType.HEIGHT_RELATIVE);
                    }
                } else if (sizing == SplitLocationType.PERCENTAGE) {
                    double cumulative = 0.0;
                    double total = 0.0;
                    for (int i = offset; i < childNodes.getLength(); ++i) {
                        double height = this.getNodeHeight(childNodes.item(i)).doubleValue();
                        if (i == offset) {
                            cumulative += height;
                        }
                        total += height;
                    }
                    splitter.setResizeWeight(cumulative / total);
                    splitter.putClientProperty(PROPERTY_SPLIT_LOCATION, cumulative / total);
                    splitter.putClientProperty(PROPERTY_SPLIT_LOCATION_TYPE, (Object)sizing);
                }
            }
        } else {
            JPanel panel2 = new JPanel();
            panel2.setLayout(new BorderLayout());
            panel.add((Component)panel2, "Center");
            this.parseRow(childNodes.item(offset), panel2);
        }
    }

    private void parseRow(Node node, JPanel panel) {
        this.parseCellSet(node.getChildNodes(), 0, panel, this.widthSizingType(node.getChildNodes()));
    }

    private void parseCellSet(NodeList childNodes, int offset, JPanel panel, SplitLocationType sizing) {
        if (offset == childNodes.getLength()) {
            return;
        }
        if (childNodes.item(offset).getNodeType() == 3) {
            this.parseCellSet(childNodes, offset + 1, panel, sizing);
        } else if (offset < childNodes.getLength() - 1) {
            Node attrOneTouchExpandable = childNodes.item(offset).getAttributes().getNamedItem("oneTouchExpandable");
            boolean oneTouchExpandable = attrOneTouchExpandable == null || attrOneTouchExpandable.getTextContent().equalsIgnoreCase("true");
            JSplitPane splitter = new JSplitPane();
            this.splitPanes.add(splitter);
            splitter.setResizeWeight(((double)childNodes.getLength() - (double)offset - 1.0) / (double)childNodes.getLength());
            splitter.setOrientation(1);
            splitter.setOneTouchExpandable(oneTouchExpandable);
            JPanel left = new JPanel();
            left.setLayout(new BorderLayout());
            splitter.setLeftComponent(left);
            panel.add((Component)splitter, "Center");
            JPanel right = new JPanel();
            right.setLayout(new BorderLayout());
            this.parseCell(childNodes.item(offset), left);
            this.parseCellSet(childNodes, offset + 1, right, sizing);
            splitter.setRightComponent(right);
            if (sizing != null) {
                if (sizing == SplitLocationType.ABSOLUTE) {
                    Number width = this.getNodeWidth(childNodes.item(offset));
                    if (width != null) {
                        splitter.putClientProperty(PROPERTY_SPLIT_LOCATION, width);
                        splitter.putClientProperty(PROPERTY_SPLIT_LOCATION_TYPE, (Object)sizing);
                    } else if (offset == childNodes.getLength() - 2 && (width = this.getNodeWidth(childNodes.item(offset + 1))) != null) {
                        splitter.putClientProperty(PROPERTY_SPLIT_LOCATION, width);
                        splitter.putClientProperty(PROPERTY_SPLIT_LOCATION_TYPE, (Object)SplitLocationType.WIDTH_RELATIVE);
                    }
                } else if (sizing == SplitLocationType.PERCENTAGE) {
                    double cumulative = 0.0;
                    double total = 0.0;
                    for (int i = offset; i < childNodes.getLength(); ++i) {
                        double width = this.getNodeWidth(childNodes.item(i)).doubleValue();
                        if (i == offset) {
                            cumulative += width;
                        }
                        total += width;
                    }
                    splitter.setResizeWeight(cumulative / total);
                    splitter.putClientProperty(PROPERTY_SPLIT_LOCATION, cumulative / total);
                    splitter.putClientProperty(PROPERTY_SPLIT_LOCATION_TYPE, (Object)sizing);
                }
            }
        } else {
            JPanel panel2 = new JPanel();
            panel2.setLayout(new BorderLayout());
            panel.add((Component)panel2, "Center");
            this.parseCell(childNodes.item(offset), panel2);
        }
    }

    private void parseCell(Node node, JPanel panel) {
        Node child = node.getChildNodes().item(0);
        int i = 1;
        while (child.getNodeType() == 3) {
            child = node.getChildNodes().item(i++);
        }
        if (child.getNodeName().equals("components")) {
            boolean hide = false;
            if (child.getAttributes().getNamedItem("hidetabs") != null && child.getAttributes().getNamedItem("hidetabs").getNodeValue().equals("true")) {
                hide = true;
            }
            Slot holder = new Slot(child.getAttributes().getNamedItem("id").getNodeValue(), hide);
            this.idmappings.put(child.getAttributes().getNamedItem("id").getNodeValue(), holder);
            panel.add(holder);
        } else if (child.getNodeName().equals("table")) {
            this.parseTableElement(child, panel);
        } else if (child.getNodeName().equals("document_viewer")) {
            this.documentViewer = new JPanel();
            panel.add(this.documentViewer);
        }
    }

    public class Slot
    extends JPanel {
        private static final long serialVersionUID = 1L;
        boolean hideTabs;
        private HashMap<JComponent, String> components = new HashMap();
        private JTabbedPane tabbed = new JTabbedPane();
        private String slotID;

        public Slot(String slotID, boolean hideTabs) {
            this.slotID = slotID;
            this.hideTabs = hideTabs;
            this.setLayout(new BorderLayout());
        }

        public void addComponent(String name, JComponent component) {
            if (this.components.containsKey(component)) {
                throw new IllegalArgumentException("This component has yet been added to this slot: " + this.slotID + " component: " + component);
            }
            if (this.components.size() == 0) {
                if (this.hideTabs) {
                    this.add((Component)component, "Center");
                    this.validate();
                } else {
                    this.add((Component)this.tabbed, "Center");
                }
            } else if (this.hideTabs && this.components.size() == 1) {
                JComponent currentChild = (JComponent)this.getComponent(0);
                this.remove(currentChild);
                this.add((Component)this.tabbed, "Center");
                this.tabbed.addTab(this.components.get(currentChild), currentChild);
            }
            if (!this.hideTabs || this.components.size() > 0) {
                this.tabbed.addTab(name, component);
            }
            this.components.put(component, name);
        }

        public void removeComponent(JComponent component) {
            if (!this.components.containsKey(component)) {
                return;
            }
            this.components.remove(component);
            if (!this.hideTabs || this.components.size() > 0) {
                this.tabbed.remove(component);
            }
            if (this.components.size() == 1) {
                if (this.hideTabs) {
                    this.remove(this.tabbed);
                    this.add((Component)component, "Center");
                    this.validate();
                }
            } else if (this.components.size() == 0) {
                if (this.hideTabs) {
                    this.remove(component);
                    this.validate();
                } else {
                    this.tabbed.remove(component);
                }
            }
        }
    }

    private static enum SplitLocationType {
        PERCENTAGE,
        ABSOLUTE,
        HEIGHT_RELATIVE,
        WIDTH_RELATIVE;

    }
}

