/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.s2p.gui.quantification;

import es.uvigo.ei.sing.s2p.core.entities.quantification.ProteinSummary;
import es.uvigo.ei.sing.s2p.core.entities.quantification.QuantificationCondition;
import es.uvigo.ei.sing.s2p.core.entities.quantification.QuantificationConditionSummary;
import es.uvigo.ei.sing.s2p.core.entities.quantification.QuantificationConditionsSummary;
import es.uvigo.ei.sing.s2p.core.entities.quantification.QuantificationDataset;
import es.uvigo.ei.sing.s2p.core.operations.quantification.QuantificationConditionsSummarizer;
import es.uvigo.ei.sing.s2p.core.operations.quantification.comparison.ProteinSummaryTest;
import es.uvigo.ei.sing.s2p.gui.charts.ChartDataSeriesDialog;
import es.uvigo.ei.sing.s2p.gui.charts.DataSeries;
import es.uvigo.ei.sing.s2p.gui.quantification.QuantificationTableModel;
import es.uvigo.ei.sing.s2p.gui.table.ExtendedCsvTable;
import es.uvigo.ei.sing.s2p.gui.util.ColorUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.swingx.renderer.DefaultTableRenderer;

public class QuantificationTable
extends ExtendedCsvTable {
    private static final long serialVersionUID = 1L;
    private QuantificationDataset dataset;
    private QuantificationConditionsSummary datasetSummary;
    private List<QuantificationCondition> conditions;
    private HashMap<QuantificationCondition, Color> conditionsColors;

    public QuantificationTable(QuantificationDataset dataset, ProteinSummaryTest proteinComparison) {
        super(new QuantificationTableModel(dataset, proteinComparison));
        this.dataset = dataset;
        this.init();
    }

    private void init() {
        this.conditions = this.dataset.getConditions();
        this.datasetSummary = QuantificationConditionsSummarizer.summary((QuantificationDataset)this.dataset);
        this.initColors();
        this.setColumVisibilityActionsEnabled(false);
        this.addExportToCsvAction();
        this.setHorizontalScrollEnabled(true);
        this.packAll();
        ConditionsSummaryTableCellRenderer renderer = new ConditionsSummaryTableCellRenderer();
        this.setDefaultRenderer(String.class, (TableCellRenderer)((Object)renderer));
        this.setDefaultRenderer(Double.class, (TableCellRenderer)((Object)renderer));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JTable table = (JTable)e.getSource();
                Point p = e.getPoint();
                int row = table.rowAtPoint(p);
                if (e.getClickCount() == 2 && row != -1) {
                    QuantificationTable.this.doubleClickAtRow(table.convertRowIndexToModel(row));
                }
            }
        });
    }

    protected void doubleClickAtRow(int rowModelIndex) {
        String clickedProtein = this.getTableModel().getProteinAt(rowModelIndex);
        ChartDataSeriesDialog dialog = new ChartDataSeriesDialog(this.getDialogParent(), clickedProtein, "", "Normalized protein values", this.getChartDataForProtein(clickedProtein));
        dialog.setVisible(true);
    }

    private List<DataSeries> getChartDataForProtein(String clickedProtein) {
        LinkedList<DataSeries> chartData = new LinkedList<DataSeries>();
        for (QuantificationCondition qC : this.datasetSummary.keySet()) {
            List proteinValues = ((ProteinSummary)((QuantificationConditionSummary)this.datasetSummary.get((Object)qC)).get((Object)clickedProtein)).getNormalizedProteinValues();
            if (proteinValues.isEmpty()) continue;
            String condition = qC.getName();
            chartData.add(new DataSeries(condition, this.getConditionColor(condition), proteinValues));
        }
        return chartData;
    }

    private Color getConditionColor(String condition) {
        return this.conditionsColors.get(this.findQuantificationCondition(condition));
    }

    private QuantificationCondition findQuantificationCondition(String name) {
        return this.conditions.stream().filter(q -> q.getName().equals(name)).findFirst().get();
    }

    private Window getDialogParent() {
        return SwingUtilities.getWindowAncestor((Component)((Object)this));
    }

    private void initColors() {
        this.conditionsColors = new HashMap();
        this.conditions.forEach(c -> {
            Color conditionColor = ColorUtils.getSoftColor(this.conditions.indexOf(c));
            this.conditionsColors.put((QuantificationCondition)c, conditionColor);
        });
    }

    public QuantificationTableModel getTableModel() {
        return (QuantificationTableModel)this.getModel();
    }

    public Map<QuantificationCondition, Color> getConditionColors() {
        return this.conditionsColors;
    }

    private class ConditionsSummaryTableCellRenderer
    extends DefaultTableRenderer {
        private static final long serialVersionUID = 1L;

        private ConditionsSummaryTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            int columnModel = table.convertColumnIndexToModel(column);
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            JLabel label = (JLabel)c;
            Optional<QuantificationCondition> condition = QuantificationTable.this.getTableModel().getConditionAt(columnModel);
            if (condition.isPresent()) {
                c.setBackground((Color)QuantificationTable.this.conditionsColors.get(condition.get()));
                if (!(value instanceof String)) {
                    String cellValue;
                    Double doubleValue = Double.parseDouble(value.toString());
                    String string = cellValue = Double.isNaN(doubleValue) ? "" : String.format("%6.2e", doubleValue);
                    if (!cellValue.isEmpty()) {
                        label.setToolTipText(doubleValue.toString());
                    }
                    label.setText(cellValue);
                }
            } else if (!(value instanceof String)) {
                double d = Double.parseDouble(value.toString());
                if (d < 0.05) {
                    label.setFont(c.getFont().deriveFont(1));
                    label.setForeground(new Color(237, 67, 55));
                } else if (Double.isNaN(d)) {
                    label.setText("");
                }
            }
            return c;
        }
    }
}

