/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.math.statistical.tests;

import java.io.Serializable;

public class FisherExactTest
implements Serializable {
    private static final long serialVersionUID = 1L;
    private double[] f;
    private int maxSize;

    public FisherExactTest() {
        this(0);
    }

    public FisherExactTest(int maxSize) {
        this.maxSize = maxSize;
        this.f = new double[maxSize + 1];
        this.f[0] = 0.0;
        this.computeF(1);
    }

    public void updateFMatrix(int maxSize) {
        if (maxSize > this.maxSize) {
            double[] oldF = this.f;
            this.f = new double[maxSize + 1];
            System.arraycopy(oldF, 0, this.f, 0, oldF.length);
            this.maxSize = maxSize;
            this.computeF(oldF.length);
        }
    }

    protected void computeF(int from) {
        int i = from;
        while (i <= this.maxSize) {
            this.f[i] = this.f[i - 1] + Math.log(i);
            ++i;
        }
    }

    public final double getP(int a, int b, int c, int d) {
        int n = a + b + c + d;
        if (n > this.maxSize) {
            this.updateFMatrix(n);
        }
        return Math.exp(this.f[a + b] + this.f[c + d] + this.f[a + c] + this.f[b + d] - (this.f[a] + this.f[b] + this.f[c] + this.f[d] + this.f[n]));
    }

    public final double getCumlativeP(int a, int b, int c, int d) {
        int i;
        int min;
        double p = this.getP(a, b, c, d);
        if (a * d >= b * c) {
            min = c < b ? c : b;
            i = 0;
            while (i < min) {
                p += this.getP(++a, --b, --c, ++d);
                ++i;
            }
        }
        if (a * d < b * c) {
            min = a < d ? a : d;
            i = 0;
            while (i < min) {
                p += this.getP(--a, ++b, ++c, --d);
                ++i;
            }
        }
        return p;
    }

    public final double getRightTailedP(int a, int b, int c, int d) {
        int min = c < b ? c : b;
        double p = this.getP(a, b, c, d);
        int i = 0;
        while (i < min) {
            p += this.getP(++a, --b, --c, ++d);
            ++i;
        }
        return p;
    }

    public final double getRightTailedPQuick(int a, int b, int c, int d, double maxP) {
        int min = c < b ? c : b;
        double p = this.getP(a, b, c, d);
        int i = 0;
        while (i < min && p < maxP) {
            p += this.getP(++a, --b, --c, ++d);
            ++i;
        }
        return p;
    }

    public final double getLeftTailedP(int a, int b, int c, int d) {
        int min = a < d ? a : d;
        double p = this.getP(a, b, c, d);
        int i = 0;
        while (i < min) {
            p += this.getP(--a, ++b, ++c, --d);
            ++i;
        }
        return p;
    }

    public final double getTwoTailedP(int a, int b, int c, int d) {
        double baseP = this.getP(a, b, c, d);
        int min1 = c < b ? c : b;
        int initialA = a;
        int initialB = b;
        int initialC = c;
        int initialD = d;
        double p = baseP;
        int i = 0;
        while (i < min1) {
            double tempP;
            if ((tempP = this.getP(++a, --b, --c, ++d)) <= baseP) {
                p += tempP;
            }
            ++i;
        }
        a = initialA;
        b = initialB;
        c = initialC;
        d = initialD;
        int min2 = a < d ? a : d;
        int i2 = 0;
        while (i2 < min2) {
            double pTemp;
            if ((pTemp = this.getP(--a, ++b, ++c, --d)) <= baseP) {
                p += pTemp;
            }
            ++i2;
        }
        return p;
    }
}

