/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.aibench.plugins.recentfiles;

import es.uvigo.ei.aibench.Launcher;
import es.uvigo.ei.aibench.core.Core;
import es.uvigo.ei.aibench.core.ParamSpec;
import es.uvigo.ei.aibench.core.PluginsObjectInputStream;
import es.uvigo.ei.aibench.core.history.HistoryElement;
import es.uvigo.ei.aibench.core.history.HistoryListener;
import es.uvigo.ei.aibench.core.operation.OperationDefinition;
import es.uvigo.ei.aibench.workbench.Workbench;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import org.platonos.pluginengine.Plugin;

public class RecentFilesHistory
implements HistoryListener {
    private static final String DEFAULT_RECENT_MENU_NAME = "Open recent";
    private static final int DEFAULT_RECENT_OPERATIONS = 15;
    private static final Object CLEAR_HISTORY_TOOLTIP = "Removes all recent history elements.";
    private static final Object REMOVE_FILES_TOOLTIP = "Removes history elements associated to files that no longer exist.";
    private List<String> operationUids;
    private RecentFilesList history;
    private String openRecentMenuName;
    private Icon openRecentMenuIcon;
    private JMenuBar menuBar;
    private JMenu menu;
    private AbstractAction clearHistoryAction;
    private AbstractAction removeFilesAction;
    private File historyFile;
    private String plugin;

    public RecentFilesHistory(String[] operationUids, String pluginId, JMenuBar menuBar, File historyFile) {
        this(operationUids, pluginId, menuBar, "", historyFile);
    }

    public RecentFilesHistory(String[] operationUids, String pluginId, JMenuBar menuBar, String parentMenu, File historyFile) {
        this(operationUids, pluginId, menuBar, parentMenu, historyFile, 15);
    }

    public RecentFilesHistory(String[] operationUids, String pluginId, JMenuBar menuBar, String parentMenu, File historyFile, int historySize) {
        this(operationUids, pluginId, menuBar, parentMenu, historyFile, historySize, DEFAULT_RECENT_MENU_NAME, null);
    }

    public RecentFilesHistory(String[] operationUids, String pluginId, JMenuBar menuBar, String parentMenu, File historyFile, int historySize, Icon menuIcon) {
        this(operationUids, pluginId, menuBar, parentMenu, historyFile, historySize, DEFAULT_RECENT_MENU_NAME, menuIcon);
    }

    public RecentFilesHistory(String[] operationUids, String pluginId, JMenuBar menuBar, String parentMenu, File historyFile, int historySize, String menuName, Icon menuIcon) {
        this.operationUids = this.checkOperationUids(operationUids);
        this.history = new RecentFilesList(historySize);
        this.openRecentMenuName = menuName;
        this.openRecentMenuIcon = menuIcon;
        this.historyFile = historyFile;
        this.menuBar = menuBar;
        this.plugin = pluginId;
        this.createRecentFilesHistoryMenu(parentMenu);
        this.loadHistory();
    }

    private List<String> checkOperationUids(String[] uids) {
        LinkedList<String> validOperations = new LinkedList<String>();
        LinkedList<String> invalidFileOperations = new LinkedList<String>();
        LinkedList<String> withNotSerializableParameters = new LinkedList<String>();
        String[] stringArray = uids;
        int n = uids.length;
        int n2 = 0;
        while (n2 < n) {
            String uid = stringArray[n2];
            OperationDefinition operation = Core.getInstance().getOperationById(uid);
            if (operation.getIncomingArgumentTypes().contains(File.class)) {
                if (!RecentFilesHistory.allParamsAreSerializable(operation)) {
                    withNotSerializableParameters.add(uid);
                } else {
                    validOperations.add(uid);
                }
            } else {
                invalidFileOperations.add(uid);
            }
            ++n2;
        }
        this.processInvalidOperations(invalidFileOperations, " as they does not contain one Port of type File");
        this.processInvalidOperations(withNotSerializableParameters, " as they contain at least one Port of a not serializable type");
        return validOperations;
    }

    private static boolean allParamsAreSerializable(OperationDefinition<?> operation) {
        boolean allParamsAreSerializable = true;
        for (Class a : operation.getIncomingArgumentTypes()) {
            if (RecentFilesHistory.isSerializable(a)) continue;
            allParamsAreSerializable = false;
            break;
        }
        return allParamsAreSerializable;
    }

    private static boolean isSerializable(Class<?> a) {
        if (a.isPrimitive()) {
            return true;
        }
        return Serializable.class.isAssignableFrom(a);
    }

    private void processInvalidOperations(List<String> uids, String reason) {
        if (!uids.isEmpty()) {
            String uidsStr = uids.stream().collect(Collectors.joining(", ")).toString();
            Workbench.getInstance().warn("Recent files history: skipping operation(s) with uid(s) " + uidsStr + reason);
        }
    }

    private void createRecentFilesHistoryMenu(String parentMenu) {
        if (parentMenu.isEmpty()) {
            this.menuBar.add((Component)this.getOpenRecentFilesMenu(), 0);
        } else {
            JMenu parent = RecentFilesHistory.findMenu(this.menuBar, parentMenu);
            if (parent == null) {
                parent = new JMenu(parentMenu);
                this.menuBar.add((Component)parent, 0);
            }
            parent.add((Component)this.getOpenRecentFilesMenu(), 0);
        }
    }

    private static JMenu findMenu(JMenuBar menuBar, String menuName) {
        JMenu parent = null;
        int i = 0;
        while (i < menuBar.getMenuCount()) {
            if (menuBar.getMenu(i).getText().equals(menuName)) {
                parent = menuBar.getMenu(i);
            }
            ++i;
        }
        return parent;
    }

    private JMenu getOpenRecentFilesMenu() {
        this.menu = new JMenu(this.openRecentMenuName);
        if (this.openRecentMenuIcon != null) {
            this.menu.setIcon(this.openRecentMenuIcon);
        }
        return this.menu;
    }

    private void loadHistory() {
        if (this.historyFile.exists()) {
            try {
                FileInputStream fis = new FileInputStream(this.historyFile);
                PluginsObjectInputStream ois = new PluginsObjectInputStream((InputStream)fis, this.getPlugin());
                this.history = (RecentFilesList)ois.readObject();
                ois.close();
                fis.close();
            }
            catch (IOException | ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        this.updateMenu();
    }

    private Plugin getPlugin() {
        return Launcher.pluginEngine.getPlugin(this.plugin);
    }

    public void persistHistory() {
        try {
            FileOutputStream fos = new FileOutputStream(this.historyFile);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(this.history);
            oos.close();
            fos.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void historyElementAdded(HistoryElement arg0) {
        if (this.triggerOperation(arg0.getOperation())) {
            this.addFileOperation(new FileOperation(arg0.getOperation().getID(), arg0.getParams()));
        }
    }

    private boolean triggerOperation(OperationDefinition<?> operation) {
        return this.operationUids.contains(operation.getID());
    }

    private void addFileOperation(FileOperation operation) {
        if (!this.history.contains(operation)) {
            this.history.add(operation);
            this.updateMenu();
            this.persistHistory();
        }
    }

    private void updateMenu() {
        this.menu.removeAll();
        int i = 0;
        while (i < this.history.size()) {
            FileOperation operation = (FileOperation)this.history.get(i);
            this.menu.add(new JMenuItem(new FileOperationAction(operation, String.valueOf(i + 1) + ". " + operation.getFile().getAbsolutePath())));
            ++i;
        }
        this.menu.add(this.getSeparator());
        this.menu.add(this.getClearHistoryAction());
        this.menu.add(this.getRemoveFilesAction());
    }

    private JSeparator getSeparator() {
        JSeparator separator = new JSeparator(0);
        separator.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        return separator;
    }

    private Action getClearHistoryAction() {
        if (this.clearHistoryAction == null) {
            this.clearHistoryAction = new AbstractAction("Clear history"){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    RecentFilesHistory.this.clearHistory();
                }
            };
            this.clearHistoryAction.putValue("ShortDescription", CLEAR_HISTORY_TOOLTIP);
        }
        return this.clearHistoryAction;
    }

    private void clearHistory() {
        this.removeFromHistory(this.history);
        this.persistHistory();
    }

    private Action getRemoveFilesAction() {
        if (this.removeFilesAction == null) {
            this.removeFilesAction = new AbstractAction("Remove deleted files"){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    RecentFilesHistory.this.removeDeletedFiles();
                }
            };
            this.removeFilesAction.putValue("ShortDescription", REMOVE_FILES_TOOLTIP);
        }
        return this.removeFilesAction;
    }

    private void removeDeletedFiles() {
        LinkedList<FileOperation> obsolete = new LinkedList<FileOperation>();
        for (FileOperation h : this.history) {
            if (h.getFile().exists()) continue;
            obsolete.add(h);
        }
        this.removeFromHistory(obsolete);
    }

    private void removeFromHistory(List<FileOperation> obsolete) {
        this.history.removeAll(obsolete);
        this.updateMenu();
        this.persistHistory();
    }

    public void historyElementRemoved(HistoryElement arg0) {
    }

    public void setClearHistoryIcon(ImageIcon icon) {
        this.getClearHistoryAction().putValue("SmallIcon", icon);
    }

    public void setRemoveFilesIcon(ImageIcon icon) {
        this.getRemoveFilesAction().putValue("SmallIcon", icon);
    }

    private static class FileOperation
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String operationUid;
        private List<?> params;
        private File file;

        public FileOperation(String operationUid, ParamSpec[] params) {
            this.operationUid = operationUid;
            this.params = FileOperation.toParamsList(params);
            this.file = this.findFile();
        }

        private static List<?> toParamsList(ParamSpec[] params2) {
            LinkedList<Object> paramsList = new LinkedList<Object>();
            ParamSpec[] paramSpecArray = params2;
            int n = params2.length;
            int n2 = 0;
            while (n2 < n) {
                ParamSpec p = paramSpecArray[n2];
                paramsList.add(p.getRawValue());
                ++n2;
            }
            return paramsList;
        }

        private File findFile() {
            for (Object param : this.params) {
                if (!param.getClass().equals(File.class)) continue;
                return (File)param;
            }
            throw new RuntimeException("Operation with uid " + this.operationUid + " does not contain any port of type File");
        }

        public List<?> getParams() {
            return this.params;
        }

        public File getFile() {
            return this.file;
        }

        public boolean equals(Object aThat) {
            if (aThat == null) {
                return false;
            }
            if (!(aThat instanceof FileOperation)) {
                return false;
            }
            FileOperation that = (FileOperation)aThat;
            return this.operationUid.equals(that.operationUid) && this.file.equals(that.file);
        }

        public String getOperationUid() {
            return this.operationUid;
        }
    }

    private static class FileOperationAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private FileOperation operation;

        public FileOperationAction(FileOperation operation, String name) {
            super(name);
            this.operation = operation;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.runOperation();
        }

        private void runOperation() {
            Core.getInstance().executeOperation(this.operation.getOperationUid(), null, this.operation.getParams());
        }
    }

    private static class LimitedQueue<E>
    extends LinkedList<E> {
        private static final long serialVersionUID = 1L;
        private int limit;

        public LimitedQueue(int limit) {
            this.limit = limit;
        }

        @Override
        public boolean add(E o) {
            boolean added = super.add(o);
            while (added && this.size() > this.limit) {
                super.remove();
            }
            return added;
        }
    }

    private static class RecentFilesList
    extends LimitedQueue<FileOperation> {
        private static final long serialVersionUID = 1L;

        public RecentFilesList(int limit) {
            super(limit);
        }
    }
}

