/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.s2p.core.io.samespots;

import es.uvigo.ei.sing.commons.csv.entities.CsvFormat;
import es.uvigo.ei.sing.s2p.core.entities.Pair;
import es.uvigo.ei.sing.s2p.core.entities.SameSpotsThrehold;
import es.uvigo.ei.sing.s2p.core.entities.Sample;
import es.uvigo.ei.sing.s2p.core.io.samespots.AbstractSameSpotsDirectoryLoader;
import es.uvigo.ei.sing.s2p.core.io.samespots.SameSpotsCsvFileLoader;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class SameSpotsCsvDirectoryLoader
extends AbstractSameSpotsDirectoryLoader {
    private CsvFormat format;

    private SameSpotsCsvDirectoryLoader(CsvFormat format) {
        this.format = format;
    }

    public static List<Sample> loadDirectory(File directory, SameSpotsThrehold threshold, CsvFormat format) throws IOException {
        SameSpotsCsvDirectoryLoader loader = new SameSpotsCsvDirectoryLoader(format);
        return loader.load(directory, threshold);
    }

    @Override
    protected List<File> listFiles(File directory) {
        return Arrays.asList(directory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().endsWith(".csv");
            }
        }));
    }

    @Override
    protected List<Sample> loadFile(File file, SameSpotsThrehold threshold) throws IOException {
        Pair<Sample, Sample> samples = SameSpotsCsvFileLoader.load(file, threshold, this.format);
        return new LinkedList<Sample>(Arrays.asList(samples.getFirst(), samples.getSecond()));
    }
}

