/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.gc4s.input;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.swing.JComboBox;
import org.sing_group.gc4s.combobox.ComboBoxItem;
import org.sing_group.gc4s.input.InputParameter;
import org.sing_group.gc4s.input.InputParametersPanel;
import org.sing_group.gc4s.ui.CenteredJPanel;
import org.sing_group.gc4s.util.Checks;

public class ItemSelectionPanel<T>
extends CenteredJPanel {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_SELECTION = "gc4s.item.selection";
    private List<T> items;
    private int n;
    private InputParameter[] inputParameters;
    private Function<T, String> namingFunction;

    public ItemSelectionPanel(List<T> items, int n) {
        this(items, n, Object::toString);
    }

    public ItemSelectionPanel(List<T> items, int n, Function<T, String> namingFunction) {
        this.items = Objects.requireNonNull(items);
        this.n = Checks.requireStrictPositive(n, "n must be greater than 0");
        this.namingFunction = Objects.requireNonNull(namingFunction);
        this.initComponent();
    }

    private void initComponent() {
        this.add(this.createInputParametersPanel());
    }

    private Component createInputParametersPanel() {
        return new InputParametersPanel(this.getInputParameters());
    }

    private InputParameter[] getInputParameters() {
        this.inputParameters = new InputParameter[this.n];
        for (int i = 0; i < this.n; ++i) {
            this.inputParameters[i] = this.createInputParameter(i);
        }
        return this.inputParameters;
    }

    private InputParameter createInputParameter(int i) {
        JComboBox comboBox = new JComboBox();
        this.getComboBoxItems().forEach(comboBox::addItem);
        String itemName = "Item " + (i + 1);
        if (i < comboBox.getItemCount()) {
            comboBox.setSelectedIndex(i);
        }
        comboBox.addItemListener(this::itemSelectionChanged);
        return new InputParameter(itemName, comboBox, itemName);
    }

    private List<ComboBoxItem<T>> getComboBoxItems() {
        ArrayList<ComboBoxItem<T>> cmbItems = new ArrayList<ComboBoxItem<T>>();
        for (T i : this.items) {
            cmbItems.add(new ComboBoxItem<T>(i, this.namingFunction.apply(i)));
        }
        return cmbItems;
    }

    private void itemSelectionChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            this.firePropertyChange(PROPERTY_SELECTION, null, this.getSelectedItems());
        }
    }

    public List<T> getSelectedItems() {
        ArrayList<T> selectedItems = new ArrayList<T>();
        for (int i = 0; i < this.n; ++i) {
            JComboBox comboBox = (JComboBox)this.inputParameters[i].getInput();
            selectedItems.add(this.items.get(comboBox.getSelectedIndex()));
        }
        return selectedItems;
    }
}

