/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.s2p.gui.plate;

import com.itextpdf.text.DocumentException;
import es.uvigo.ei.sing.commons.csv.entities.CsvFormat;
import es.uvigo.ei.sing.commons.csv.io.CsvWriter;
import es.uvigo.ei.sing.s2p.core.entities.MaldiPlate;
import es.uvigo.ei.sing.s2p.gui.components.dialog.ExportCsvDialog;
import es.uvigo.ei.sing.s2p.gui.plate.MaldiPlateInformationEditor;
import es.uvigo.ei.sing.s2p.gui.util.CommonFileChooser;
import es.uvigo.ei.sing.s2p.gui.util.CsvUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.RowSorter;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.sing_group.gc4s.table.RowHeaderExtendedJXTable;
import org.sing_group.gc4s.utilities.ExtendedAbstractAction;
import org.sing_group.gc4s.utilities.MatrixUtils;

public class MaldiPlateTable
extends JPanel {
    private static final long serialVersionUID = 1L;
    private MaldiPlate plate;
    protected RowHeaderExtendedJXTable table;

    public MaldiPlateTable(MaldiPlate plate) {
        this.plate = plate;
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.add(this.getInfoEditorPanel(), "North");
        this.add((Component)new JScrollPane(this.getMaldiPlateTable()), "Center");
    }

    private Component getInfoEditorPanel() {
        MaldiPlateInformationEditor editor = new MaldiPlateInformationEditor(this.plate.getInfo());
        editor.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return editor;
    }

    private Component getMaldiPlateTable() {
        this.table = new RowHeaderExtendedJXTable((Object[][])this.plate.getData(), this.plate.getColNames().toArray(), this.plate.getRowNames().toArray());
        this.configureTable();
        return this.table;
    }

    protected void configureTable() {
        this.table.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.table.setColumVisibilityActionsEnabled(false);
        this.table.setColumnControlVisible(true);
        this.table.setColumnSelectionAllowed(false);
        this.table.setRowSelectionAllowed(false);
        this.table.setCellSelectionEnabled(true);
        this.table.setSelectionMode(2);
        this.table.setEditable(true);
        this.table.setHorizontalScrollEnabled(true);
        this.table.putClientProperty((Object)"terminateEditOnFocusLost", (Object)true);
        this.table.getModel().addTableModelListener(this::tableChanged);
        this.table.setFont(this.table.getFont().deriveFont(14.0f));
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setRowSorter((RowSorter)new TableRowSorter<TableModel>(this.table.getModel()){

            @Override
            public boolean isSortable(int column) {
                return false;
            }
        });
        this.table.addAction((Action)new ExtendedAbstractAction("Export to CSV", this::exportToCsv));
        this.table.addAction((Action)new ExtendedAbstractAction("Export as PDF", this::exportToPdf));
        this.table.addAction((Action)new ExtendedAbstractAction("Save plate", this::savePlate));
        this.table.packAll();
    }

    private void exportToPdf() {
        JFileChooser fileChooser = CommonFileChooser.getInstance().getFilechooser();
        int result = fileChooser.showSaveDialog(this);
        if (result == 0) {
            File selectedFile = fileChooser.getSelectedFile();
            if (!selectedFile.getName().endsWith("pdf")) {
                selectedFile = new File(selectedFile.getAbsolutePath() + ".pdf");
            }
            try {
                this.plate.toPdf(selectedFile);
            }
            catch (DocumentException | FileNotFoundException e) {
                JOptionPane.showMessageDialog(this, "There was an error writing to " + selectedFile, "Input error", 0);
            }
        }
    }

    private void savePlate() {
        JFileChooser fileChooser = CommonFileChooser.getInstance().getFilechooser();
        int result = fileChooser.showSaveDialog(this);
        if (result == 0) {
            File selectedFile = fileChooser.getSelectedFile();
            if (!selectedFile.getName().endsWith(".mpl")) {
                selectedFile = new File(selectedFile.getAbsolutePath() + ".mpl");
            }
            try {
                this.plate.toFile(selectedFile);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, "There was an error writing to " + selectedFile, "Input error", 0);
            }
        }
    }

    private void tableChanged(TableModelEvent event) {
        if (event.getType() == 0) {
            this.plate.setData(this.getPlateData());
        }
    }

    private String[][] getPlateData() {
        return MatrixUtils.asStringMatrix((Object[][])MatrixUtils.removeColumn((int)0, (Object[][])this.table.getData()));
    }

    protected void exportToCsv() {
        ExportCsvDialog dialog = new ExportCsvDialog(this.getDialogParent());
        dialog.setVisible(true);
        if (!dialog.isCanceled()) {
            try {
                this.exportToFile(dialog.getSelectedFile(), CsvUtils.csvFormat(dialog.getSelectedCsvFormat()));
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, "There was an error writing to " + dialog.getSelectedFile(), "Input error", 0);
            }
        }
    }

    private Window getDialogParent() {
        return SwingUtilities.getWindowAncestor(this);
    }

    public void exportToFile(File file, CsvFormat csvFormat) throws IOException {
        List headerData = this.table.getColumnNames();
        Object[][] data = this.table.getData();
        CsvWriter csvWriter = CsvWriter.of((CsvFormat)csvFormat);
        csvWriter.write(data, headerData, file);
    }
}

