/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.s2p.core.io;

import es.uvigo.ei.sing.commons.csv.entities.CsvData;
import es.uvigo.ei.sing.commons.csv.entities.CsvEntry;
import es.uvigo.ei.sing.commons.csv.entities.CsvFormat;
import es.uvigo.ei.sing.commons.csv.io.CsvReader;
import es.uvigo.ei.sing.s2p.core.entities.MascotEntry;
import es.uvigo.ei.sing.s2p.core.entities.MascotIdentifications;
import es.uvigo.ei.sing.s2p.core.entities.SpotMascotIdentifications;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;

public class SpotMascotIdentificationsCsvLoader {
    public static SpotMascotIdentifications load(File file, CsvFormat csvFormat) throws IOException {
        CsvData data = CsvReader.CsvReaderBuilder.newCsvReaderBuilder().withFormat(csvFormat).withHeader().build().read(file);
        return SpotMascotIdentificationsCsvLoader.parseEntries(data, file);
    }

    private static SpotMascotIdentifications parseEntries(CsvData data, File file) throws IOException {
        HashMap<String, MascotIdentifications> spotToIdentifications = new HashMap<String, MascotIdentifications>();
        for (CsvEntry e : data) {
            MascotEntry entry = SpotMascotIdentificationsCsvLoader.parseEntry(e, data.getFormat(), spotToIdentifications);
            String spot = (String)e.get(0);
            spotToIdentifications.putIfAbsent(spot, new MascotIdentifications());
            ((MascotIdentifications)spotToIdentifications.get(spot)).add(entry);
        }
        return new SpotMascotIdentifications(spotToIdentifications);
    }

    private static MascotEntry parseEntry(CsvEntry entry, CsvFormat format, Map<String, MascotIdentifications> spotToIdentifications) throws IOException {
        String title = (String)entry.get(1);
        String platePosition = (String)entry.get(2);
        int mascotScore = SpotMascotIdentificationsCsvLoader.asInt((String)entry.get(3));
        int difference = SpotMascotIdentificationsCsvLoader.asInt((String)entry.get(4));
        int msCoverage = SpotMascotIdentificationsCsvLoader.asInt((String)entry.get(5));
        double proteinMW = SpotMascotIdentificationsCsvLoader.asDouble((String)entry.get(6), format);
        String method = (String)entry.get(7);
        double pIValue = SpotMascotIdentificationsCsvLoader.asDouble((String)entry.get(8), format);
        String accession = (String)entry.get(9);
        String source = (String)entry.get(10);
        return new MascotEntry(title, platePosition, mascotScore, difference, msCoverage, proteinMW, method, pIValue, accession, new File(source));
    }

    private static double asDouble(String string, CsvFormat format) throws IOException {
        try {
            return format.asDouble(string);
        }
        catch (ParseException e) {
            throw new IOException("Can't parse number " + string, e);
        }
    }

    private static int asInt(String string) throws IOException {
        try {
            return Integer.valueOf(string);
        }
        catch (NumberFormatException e) {
            throw new IOException("Can't parse number " + string, e);
        }
    }
}

