/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.s2p.core.entities.quantification;

import es.uvigo.ei.sing.s2p.core.entities.quantification.ProteinQuantification;
import es.uvigo.ei.sing.s2p.core.entities.quantification.QuantificationCondition;
import es.uvigo.ei.sing.s2p.core.entities.quantification.QuantificationReplicate;
import es.uvigo.ei.sing.s2p.core.entities.quantification.QuantificationSample;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class QuantificationDataset
extends LinkedList<QuantificationSample> {
    private static final long serialVersionUID = 1L;

    public QuantificationDataset(List<QuantificationSample> samples) {
        super(samples);
    }

    public List<QuantificationCondition> getConditions() {
        Map<String, List<QuantificationSample>> conditionSamples = this.getConditionSamples();
        return this.extractConditions(conditionSamples);
    }

    private Map<String, List<QuantificationSample>> getConditionSamples() {
        HashMap<String, List<QuantificationSample>> conditionSamples = new HashMap<String, List<QuantificationSample>>();
        this.stream().filter(s -> s.getCondition().isPresent()).forEach(s -> {
            conditionSamples.putIfAbsent(s.getCondition().get(), new LinkedList());
            ((List)conditionSamples.get(s.getCondition().get())).add(s);
        });
        return conditionSamples;
    }

    private List<QuantificationCondition> extractConditions(Map<String, List<QuantificationSample>> conditionSamples) {
        LinkedList<QuantificationCondition> conditions = new LinkedList<QuantificationCondition>();
        conditionSamples.forEach((? super K e, ? super V k) -> conditions.add(new QuantificationCondition((String)e, (List<QuantificationSample>)k)));
        return conditions;
    }

    public Set<String> getProteins() {
        return QuantificationDataset.getProteins(this.stream());
    }

    public static final Set<String> getProteins(Stream<QuantificationSample> samples) {
        return samples.map(QuantificationSample::getReplicates).flatMap(Collection::stream).map(QuantificationReplicate::getProteins).flatMap(Collection::stream).map(ProteinQuantification::getProtein).collect(Collectors.toSet());
    }
}

