/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.gc4s.utilities;

import java.awt.Color;

public class Gradient {
    public static final Color[] GRADIENT_MAROON_TO_GOLD = Gradient.createGradient(new Color(160, 0, 0), new Color(255, 255, 0), 500);
    public static final Color[] GRADIENT_BLUE_TO_RED = Gradient.createGradient(Color.BLUE, Color.RED, 500);
    public static final Color[] GRADIENT_BLACK_TO_WHITE = Gradient.createGradient(Color.BLACK, Color.WHITE, 500);
    public static final Color[] GRADIENT_RED_TO_GREEN = Gradient.createGradient(Color.RED, Color.GREEN, 500);
    public static final Color[] GRADIENT_GREEN_YELLOW_ORANGE_RED = Gradient.createMultiGradient(new Color[]{Color.green, Color.yellow, Color.orange, Color.red}, 500);
    public static final Color[] GRADIENT_RAINBOW = Gradient.createMultiGradient(new Color[]{new Color(181, 32, 255), Color.blue, Color.green, Color.yellow, Color.orange, Color.red}, 500);
    public static final Color[] GRADIENT_HOT = Gradient.createMultiGradient(new Color[]{Color.black, new Color(87, 0, 0), Color.red, Color.orange, Color.yellow, Color.white}, 500);
    public static final Color[] GRADIENT_HEAT = Gradient.createMultiGradient(new Color[]{Color.black, new Color(105, 0, 0), new Color(192, 23, 0), new Color(255, 150, 38), Color.white}, 500);
    public static final Color[] GRADIENT_ROY = Gradient.createMultiGradient(new Color[]{Color.red, Color.orange, Color.yellow}, 500);

    public static Color[] createGradient(Color one, Color two, int numSteps) {
        int r1 = one.getRed();
        int g1 = one.getGreen();
        int b1 = one.getBlue();
        int a1 = one.getAlpha();
        int r2 = two.getRed();
        int g2 = two.getGreen();
        int b2 = two.getBlue();
        int a2 = two.getAlpha();
        int newR = 0;
        int newG = 0;
        int newB = 0;
        int newA = 0;
        Color[] gradient = new Color[numSteps];
        for (int i = 0; i < numSteps; ++i) {
            double iNorm = (double)i / (double)numSteps;
            newR = (int)((double)r1 + iNorm * (double)(r2 - r1));
            newG = (int)((double)g1 + iNorm * (double)(g2 - g1));
            newB = (int)((double)b1 + iNorm * (double)(b2 - b1));
            newA = (int)((double)a1 + iNorm * (double)(a2 - a1));
            gradient[i] = new Color(newR, newG, newB, newA);
        }
        return gradient;
    }

    public static Color[] createMultiGradient(Color[] colors, int numSteps) {
        int numSections = colors.length - 1;
        int gradientIndex = 0;
        Color[] gradient = new Color[numSteps];
        if (numSections <= 0) {
            throw new IllegalArgumentException("You must pass in at least 2 colors in the array!");
        }
        for (int section = 0; section < numSections; ++section) {
            Color[] temp = Gradient.createGradient(colors[section], colors[section + 1], numSteps / numSections);
            for (int i = 0; i < temp.length; ++i) {
                gradient[gradientIndex++] = temp[i];
            }
        }
        if (gradientIndex < numSteps) {
            while (gradientIndex < numSteps) {
                gradient[gradientIndex] = colors[colors.length - 1];
                ++gradientIndex;
            }
        }
        return gradient;
    }
}

