/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.s2p.core.entities;

import es.uvigo.ei.sing.s2p.core.entities.Condition;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SpotsCount {
    private Condition condition;
    private Map<String, Integer> spotsPresence;
    private Set<String> spots;

    public SpotsCount(Condition condition) {
        this(condition, Collections.emptySet());
    }

    public SpotsCount(Condition condition, Set<String> spots) {
        this.condition = condition;
        this.spots = spots;
        this.initData();
    }

    private void initData() {
        this.spotsPresence = new HashMap<String, Integer>();
        this.spots.forEach(p -> this.spotsPresence.put((String)p, 0));
        this.condition.getSamples().forEach(s -> s.getSpotValues().keySet().forEach(key -> {
            this.spotsPresence.putIfAbsent((String)key, 0);
            this.spotsPresence.put((String)key, this.spotsPresence.get(key) + 1);
        }));
    }

    public Set<String> getSpots(int presenceThreshold) {
        HashSet<String> spots = new HashSet<String>();
        this.spotsPresence.entrySet().forEach(es -> {
            if ((Integer)es.getValue() >= presenceThreshold) {
                spots.add((String)es.getKey());
            }
        });
        return spots;
    }

    public Set<String> getSpots(int minPresenceThreshold, int maxPresenceThreshold) {
        HashSet<String> spots = new HashSet<String>();
        this.spotsPresence.entrySet().forEach(es -> {
            if ((Integer)es.getValue() >= minPresenceThreshold && (Integer)es.getValue() <= maxPresenceThreshold) {
                spots.add((String)es.getKey());
            }
        });
        return spots;
    }
}

