/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.gc4s.visualization;

import java.awt.Window;
import java.util.LinkedList;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.sing_group.gc4s.dialog.AbstractInputJDialog;
import org.sing_group.gc4s.input.InputParameter;
import org.sing_group.gc4s.input.InputParametersPanel;
import org.sing_group.gc4s.visualization.JHeatMapOperations;

public class JHeatMapDataOperationsDialog
extends AbstractInputJDialog {
    private static final long serialVersionUID = 1L;
    private static final String DESCRIPTION = "This dialog allows you to apply different operations to the current data matrix. Operations are performed in the order they appear.";
    private JPanel inputComponents;
    private JComboBox<JHeatMapOperations.Centering> centerMethod;
    private JComboBox<JHeatMapOperations.Transform> transformMethod;

    protected JHeatMapDataOperationsDialog(Window parent) {
        super(parent);
    }

    @Override
    protected String getDialogTitle() {
        return "Operations dialog";
    }

    @Override
    protected String getDescription() {
        return DESCRIPTION;
    }

    @Override
    protected JPanel getInputComponentsPane() {
        if (this.inputComponents == null) {
            this.inputComponents = new InputParametersPanel(this.getParameters());
        }
        return this.inputComponents;
    }

    private InputParameter[] getParameters() {
        LinkedList<InputParameter> toret = new LinkedList<InputParameter>();
        toret.add(this.getLogTransformationParameter());
        toret.add(this.getCenteringParameter());
        return toret.toArray(new InputParameter[toret.size()]);
    }

    private InputParameter getLogTransformationParameter() {
        return new InputParameter("Transform", this.getTransformationComponent(), "The transformation method. It is applied to each individual value of the data matrix.");
    }

    private JComponent getTransformationComponent() {
        this.transformMethod = new JComboBox<JHeatMapOperations.Transform>(JHeatMapOperations.Transform.values());
        return this.transformMethod;
    }

    public JHeatMapOperations.Transform getTransform() {
        return (JHeatMapOperations.Transform)((Object)this.transformMethod.getSelectedItem());
    }

    private InputParameter getCenteringParameter() {
        return new InputParameter("Row centering", this.getCenteringComponent(), "The row centering method.");
    }

    private JComponent getCenteringComponent() {
        this.centerMethod = new JComboBox<JHeatMapOperations.Centering>(JHeatMapOperations.Centering.values());
        return this.centerMethod;
    }

    public JHeatMapOperations.Centering getCentering() {
        return (JHeatMapOperations.Centering)((Object)this.centerMethod.getSelectedItem());
    }

    @Override
    public void setVisible(boolean b) {
        this.okButton.setEnabled(true);
        this.pack();
        super.setVisible(b);
    }
}

