/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.gc4s.ui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CardsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_VISIBLE_CARD = "gc4s.cardspanel.visiblecard";
    private JPanel cards;
    private Map<Object, Component> cardsMap;
    private JComboBox<Object> cardSelectionCombo;
    private String selectionLabel;

    public CardsPanel(Map<Object, Component> cardsMap, String selectionLabel) {
        this.cardsMap = cardsMap;
        this.selectionLabel = selectionLabel;
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.add(this.getCardsPanel(), "Center");
        this.add(this.getSelectionPanel(), "North");
    }

    private Component getCardsPanel() {
        this.cards = new JPanel(new CardLayout());
        for (Object cardLabel : this.cardsMap.keySet()) {
            this.cards.add(this.cardsMap.get(cardLabel), cardLabel.toString());
        }
        return this.cards;
    }

    private Component getSelectionPanel() {
        JPanel cardsNorthPanel = new JPanel();
        cardsNorthPanel.setLayout(new FlowLayout());
        cardsNorthPanel.add(Box.createHorizontalGlue());
        cardsNorthPanel.add(new JLabel(this.selectionLabel));
        cardsNorthPanel.add(this.getCardSelectionCombo());
        return cardsNorthPanel;
    }

    private Component getCardSelectionCombo() {
        this.cardSelectionCombo = new JComboBox<Object>(this.cardsMap.keySet().toArray(new Object[this.cardsMap.size()]));
        this.cardSelectionCombo.setEditable(false);
        this.cardSelectionCombo.addItemListener(this::cardItemChanged);
        return this.cardSelectionCombo;
    }

    private void cardItemChanged(ItemEvent evt) {
        Component oldValue = this.getSelectedCard();
        CardLayout cl = (CardLayout)this.cards.getLayout();
        cl.show(this.cards, evt.getItem().toString());
        this.firePropertyChange(PROPERTY_VISIBLE_CARD, oldValue, this.getSelectedCard());
    }

    public Component getSelectedCard() {
        Component visible = null;
        for (Component c : this.cardsMap.values()) {
            if (!c.isVisible()) continue;
            visible = c;
        }
        return visible;
    }

    public static class CardsPanelBuilder {
        private Map<Object, Component> cardsMap = new HashMap<Object, Component>();
        private String selectionLabel = "Card:";

        public static CardsPanelBuilder newBuilder() {
            return new CardsPanelBuilder();
        }

        public CardsPanelBuilder withCard(Object label, Component card) {
            this.cardsMap.put(label, card);
            return this;
        }

        public CardsPanelBuilder withSelectionLabel(String label) {
            this.selectionLabel = label;
            return this;
        }

        public CardsPanel build() {
            return new CardsPanel(this.cardsMap, this.selectionLabel);
        }
    }
}

