/*
 * Decompiled with CFR 0.152.
 */
package org.platonos.pluginengine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PluginXmlNode {
    private final List<PluginXmlNode> children = new ArrayList<PluginXmlNode>(10);
    private final Map<String, String> attributes = new HashMap<String, String>(10);
    private PluginXmlNode parent = null;
    private String name = null;
    private String text = null;

    public void setAttribute(String name, String value) {
        this.attributes.put(name.toLowerCase(), value);
    }

    public String getAttribute(String name) {
        return this.attributes.get(name.toLowerCase());
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public int getAttributeCount() {
        return null != this.attributes ? this.attributes.size() : 0;
    }

    public boolean hasChildren() {
        return null != this.children && this.children.size() > 0;
    }

    public List<PluginXmlNode> getChildren() {
        return this.children;
    }

    public PluginXmlNode getChild(int index) {
        if (index > this.children.size() - 1) {
            return null;
        }
        return this.children.get(index);
    }

    public PluginXmlNode getChild(String name) {
        for (PluginXmlNode child : this.children) {
            if (!child.getName().equals(name)) continue;
            return child;
        }
        return null;
    }

    public List<PluginXmlNode> getChildren(String name) {
        ArrayList<PluginXmlNode> childrenWithName = new ArrayList<PluginXmlNode>();
        for (PluginXmlNode child : this.children) {
            if (!child.getName().equals(name)) continue;
            childrenWithName.add(child);
        }
        return childrenWithName;
    }

    public void addChild(PluginXmlNode child) {
        child.setParent(this);
        this.children.add(child);
    }

    public boolean removeChild(PluginXmlNode child) {
        child.setParent(null);
        return this.children.remove(child);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setParent(PluginXmlNode parent) {
        this.parent = parent;
    }

    public PluginXmlNode getParent() {
        return this.parent;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text == null ? "" : this.text;
    }

    public String toXML() {
        StringBuilder buffer = new StringBuilder(100);
        this.toXML(buffer);
        return buffer.toString();
    }

    void toXML(StringBuilder buffer) {
        buffer.append('<');
        buffer.append(this.getName());
        for (String name : this.getAttributes().keySet()) {
            buffer.append(' ');
            buffer.append(name);
            buffer.append("=\"");
            buffer.append(this.getAttribute(name));
            buffer.append('\"');
        }
        List<PluginXmlNode> children = this.getChildren();
        if (children.isEmpty()) {
            String text = this.getText();
            if (text.length() == 0) {
                buffer.append("/>");
            } else {
                buffer.append('>');
                buffer.append(text);
                buffer.append("</");
                buffer.append(this.getName());
                buffer.append('>');
            }
        } else {
            buffer.append('>');
            for (PluginXmlNode child : children) {
                child.toXML(buffer);
            }
            buffer.append("</");
            buffer.append(this.getName());
            buffer.append('>');
        }
    }

    public String toString() {
        return this.toXML();
    }
}

