/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.s2p.gui.spots.condition;

import es.uvigo.ei.sing.s2p.core.entities.Condition;
import es.uvigo.ei.sing.s2p.core.entities.MascotIdentifications;
import es.uvigo.ei.sing.s2p.core.entities.Sample;
import es.uvigo.ei.sing.s2p.core.entities.SpotMascotIdentifications;
import es.uvigo.ei.sing.s2p.gui.UISettings;
import es.uvigo.ei.sing.s2p.gui.samples.SamplesComparisonTable;
import es.uvigo.ei.sing.s2p.gui.spots.comparison.JHeatMapDialog;
import es.uvigo.ei.sing.s2p.gui.spots.heatmap.JHeatMapConfigurationDialog;
import es.uvigo.ei.sing.s2p.gui.spots.heatmap.SpotRenderer;
import es.uvigo.ei.sing.s2p.gui.table.spots.ConditionControlAction;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.sing_group.gc4s.utilities.ExtendedAbstractAction;

public class ConditionComparisonTable
extends JPanel {
    private static final long serialVersionUID = 1L;
    private List<Condition> conditions;
    private Map<Sample, Color> samplesColors;
    private Map<Sample, String> samplesLabels;
    private SamplesComparisonTable samplesTable;
    private boolean showProteinIdentifications = false;
    protected Optional<Map<String, MascotIdentifications>> mascotIdentifications = Optional.empty();

    public ConditionComparisonTable(List<Condition> conditions, Map<Sample, Color> samplesColors, Map<Sample, String> samplesLabels) {
        this.conditions = conditions;
        this.samplesColors = samplesColors;
        this.samplesLabels = samplesLabels;
        this.initComponent();
    }

    private void initComponent() {
        this.setLayout(new BorderLayout());
        this.add(this.getSamplesTable(), "Center");
    }

    private Component getSamplesTable() {
        this.samplesTable = new SamplesComparisonTable(this.getSamples(), this.getSampleColors(), this.getSampleLabels());
        this.samplesTable.setBorder(BorderFactory.createEmptyBorder(1, 5, 1, 5));
        this.samplesTable.setBackground(UISettings.BG_COLOR);
        this.samplesTable.addTableAction(this.getViewAsHeatmapAction());
        this.createHideConditionsActions();
        return this.samplesTable;
    }

    private void createHideConditionsActions() {
        this.conditions.forEach(c -> this.samplesTable.addTableAction(this.getHideConditionAction((Condition)c)));
    }

    private Action getHideConditionAction(Condition c) {
        return new ConditionControlAction(c, this::setConditionVisibility);
    }

    private void setConditionVisibility(Condition c, boolean visible) {
        List<Integer> columnIndices = c.getSamples().stream().map(this.getSamples()::indexOf).map(i -> i + 1).collect(Collectors.toList());
        this.samplesTable.setColumnsVisibility(columnIndices, visible);
    }

    private List<Sample> getSamples() {
        return this.getConditions().stream().map(Condition::getSamples).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private Map<Sample, Color> getSampleColors() {
        return this.samplesColors;
    }

    public Map<Sample, String> getSampleLabels() {
        return this.samplesLabels;
    }

    private List<Condition> getConditions() {
        return this.conditions;
    }

    private Action getViewAsHeatmapAction() {
        return new ExtendedAbstractAction("View as heatmap", this::viewAsHeatmap);
    }

    private void viewAsHeatmap() {
        JHeatMapConfigurationDialog configurationDialog = new JHeatMapConfigurationDialog(this.getRoot(), this.showProteinIdentifications);
        configurationDialog.setVisible(true);
        if (!configurationDialog.isCanceled()) {
            SpotRenderer renderer = new SpotRenderer(SpotRenderer.IdentificationsMode.NONE, true);
            if (this.showProteinIdentifications) {
                renderer = configurationDialog.getSelectedSpotRenderer();
            }
            JHeatMapDialog dialog = new JHeatMapDialog(this.getRoot(), this.samplesTable.getHeatMapModel(renderer, configurationDialog.isShowSampleLabels()));
            dialog.setVisible(true);
        }
    }

    private Window getRoot() {
        return SwingUtilities.getWindowAncestor(this);
    }

    public void setMascotIdentifications(SpotMascotIdentifications mascotIdentifications) {
        this.samplesTable.setMascotIdentifications(mascotIdentifications);
    }

    public void setShowProteinIdentifications(boolean show) {
        this.showProteinIdentifications = show;
        this.samplesTable.setShowProteinIdentifications(show);
    }

    public void setVisibleProteins(Set<String> visibleSpots) {
        this.samplesTable.setVisibleSpots(visibleSpots);
    }

    public void removeMascotIdentifications() {
        this.samplesTable.removeMascotIdentifications();
    }
}

