/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.s2p.gui.mascot;

import es.uvigo.ei.sing.s2p.core.entities.MascotEntry;
import es.uvigo.ei.sing.s2p.core.entities.SpotMascotIdentifications;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.table.AbstractTableModel;

public class SpotMascotIdentificationsTableModel
extends AbstractTableModel
implements Observer {
    private static final long serialVersionUID = 1L;
    private static final Map<Integer, String> TABLE_FIELDS = new HashMap<Integer, String>();
    private static final Map<Integer, Class<?>> TABLE_CLASSES;
    private Set<String> spots;
    private SpotMascotIdentifications spotIdentifications;
    private List<Object[]> rows;
    private Map<Integer, MascotEntry> rowToEntry;

    public SpotMascotIdentificationsTableModel(Set<String> spots, SpotMascotIdentifications spotIdentifications) {
        this.spots = spots;
        this.spotIdentifications = spotIdentifications;
        this.spotIdentifications.addObserver((Observer)this);
        this.initMatrixData();
    }

    private void initMatrixData() {
        this.rows = new LinkedList<Object[]>();
        this.rowToEntry = new HashMap<Integer, MascotEntry>();
        AtomicInteger rowCount = new AtomicInteger(0);
        this.spots.forEach(s -> this.spotIdentifications.get(s).forEach(identification -> {
            Object[] row = new Object[TABLE_FIELDS.size()];
            row[0] = s;
            row[1] = identification.getTitle();
            row[2] = identification.getPlatePosition();
            row[3] = new Integer(identification.getMascotScore());
            row[4] = new Integer(identification.getDifference());
            row[5] = new Integer(identification.getMsCoverage());
            row[6] = new Double(identification.getProteinMW());
            row[7] = identification.getMethod();
            row[8] = new Double(identification.getpIValue());
            row[9] = identification.getAccession();
            row[10] = identification.getSource();
            this.rows.add(row);
            this.rowToEntry.put(rowCount.getAndIncrement(), (MascotEntry)identification);
        }));
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public int getColumnCount() {
        return TABLE_FIELDS.size();
    }

    @Override
    public String getColumnName(int columnIndex) {
        return TABLE_FIELDS.get(columnIndex);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return TABLE_CLASSES.get(columnIndex);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.rows.get(rowIndex)[columnIndex];
    }

    @Override
    public void update(Observable o, Object arg) {
        this.initMatrixData();
    }

    public String getSpotAtRow(int row) {
        return this.getValueAt(row, 0).toString();
    }

    public MascotEntry getMascotEntryAtRow(int row) {
        return this.rowToEntry.get(row);
    }

    static {
        TABLE_FIELDS.put(0, "Spot");
        TABLE_FIELDS.put(1, "Title");
        TABLE_FIELDS.put(2, "Plate position");
        TABLE_FIELDS.put(3, "Score");
        TABLE_FIELDS.put(4, "Difference");
        TABLE_FIELDS.put(5, "MS Coverage");
        TABLE_FIELDS.put(6, "Protein MW");
        TABLE_FIELDS.put(7, "Method");
        TABLE_FIELDS.put(8, "pI-Value");
        TABLE_FIELDS.put(9, "Accession");
        TABLE_FIELDS.put(10, "Source");
        TABLE_CLASSES = new HashMap();
        TABLE_CLASSES.put(0, String.class);
        TABLE_CLASSES.put(1, String.class);
        TABLE_CLASSES.put(2, String.class);
        TABLE_CLASSES.put(3, Integer.class);
        TABLE_CLASSES.put(4, Integer.class);
        TABLE_CLASSES.put(5, Integer.class);
        TABLE_CLASSES.put(6, Double.class);
        TABLE_CLASSES.put(7, String.class);
        TABLE_CLASSES.put(8, Double.class);
        TABLE_CLASSES.put(9, String.class);
        TABLE_CLASSES.put(10, File.class);
    }
}

