/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.aibench.workbench.tree;

import es.uvigo.ei.aibench.Launcher;
import es.uvigo.ei.aibench.Util;
import es.uvigo.ei.aibench.core.Core;
import es.uvigo.ei.aibench.core.ParamSource;
import es.uvigo.ei.aibench.core.ParamSpec;
import es.uvigo.ei.aibench.core.clipboard.Clipboard;
import es.uvigo.ei.aibench.core.clipboard.ClipboardItem;
import es.uvigo.ei.aibench.core.clipboard.ClipboardListener;
import es.uvigo.ei.aibench.core.datatypes.annotation.Datatype;
import es.uvigo.ei.aibench.core.datatypes.annotation.Property;
import es.uvigo.ei.aibench.core.datatypes.annotation.Structure;
import es.uvigo.ei.aibench.core.history.HistoryElement;
import es.uvigo.ei.aibench.core.history.HistoryListener;
import es.uvigo.ei.aibench.workbench.Workbench;
import es.uvigo.ei.aibench.workbench.tree.AIBenchTreeMouseListener;
import es.uvigo.ei.aibench.workbench.tree.AIBenchTreeRenderer;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class AIBenchJTreeManager
implements HistoryListener,
ClipboardListener,
Serializable {
    private static final long serialVersionUID = 1L;
    private static AIBenchJTreeManager instance = null;
    private static final String CLIPBOARD_LABEL = "Clipboard";
    private static final String SESSION_HISTORY_LABEL = "Session History";
    private JTree sessionTree = null;
    private JTree clipboardTree = null;
    private static Logger logger = Logger.getLogger((String)AIBenchJTreeManager.class.getName());
    private HashMap<ClipboardItem, MutableTreeNode> clipboardMapping = new HashMap();

    public AIBenchJTreeManager() {
        if (this.sessionTree == null) {
            this.sessionTree = new JTree(new DefaultTreeModel(new DefaultMutableTreeNode(SESSION_HISTORY_LABEL)));
            this.sessionTree.addMouseListener(new AIBenchTreeMouseListener());
            this.sessionTree.setEditable(false);
            this.sessionTree.getSelectionModel().setSelectionMode(1);
            this.sessionTree.setShowsRootHandles(true);
            AIBenchTreeRenderer renderer = new AIBenchTreeRenderer();
            this.sessionTree.setCellRenderer(renderer);
            this.sessionTree.setEditable(true);
            MyTreeCellEditor editor = new MyTreeCellEditor(this.sessionTree, renderer);
            this.sessionTree.setCellEditor(editor);
            Core.getInstance().getHistory().addHistoryListener((HistoryListener)this);
        }
        if (this.clipboardTree == null) {
            this.clipboardTree = new JTree(new DefaultTreeModel(new DefaultMutableTreeNode(CLIPBOARD_LABEL)));
            this.clipboardTree.addMouseListener(new AIBenchTreeMouseListener());
            this.clipboardTree.setEditable(false);
            this.clipboardTree.getSelectionModel().setSelectionMode(1);
            this.clipboardTree.setShowsRootHandles(true);
            ToolTipManager.sharedInstance().registerComponent(this.clipboardTree);
            this.clipboardTree.setCellRenderer(new AIBenchTreeRenderer(){
                private static final long serialVersionUID = 1L;

                @Override
                public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                    JLabel c = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
                    if (!leaf && !(node.getUserObject() instanceof ClipboardItem)) {
                        String iconDatatype = Workbench.CONFIG.getProperty("icon.datatype");
                        c.setIcon(new ImageIcon(iconDatatype == null ? this.getClass().getResource("/images/datatype.png") : Util.getGlobalResourceURL((String)iconDatatype)));
                    }
                    if (node.equals(tree.getModel().getRoot())) {
                        String iconClipboard = Workbench.CONFIG.getProperty("icon.clipboard");
                        c.setText("");
                        if (iconClipboard == null) {
                            c.setIcon(new ImageIcon(this.getClass().getResource("/images/clipboard.gif")));
                        } else {
                            URL imageUrl = Launcher.class.getProtectionDomain().getCodeSource().getLocation();
                            try {
                                String imageUrlString = imageUrl.toString();
                                String baseUrl = imageUrl.getFile().endsWith(".jar") ? imageUrlString.substring(0, imageUrlString.lastIndexOf(47)) + "/" : imageUrlString;
                                c.setIcon(new ImageIcon(new URL(baseUrl + "../" + iconClipboard)));
                            }
                            catch (MalformedURLException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    return c;
                }
            });
            this.clipboardTree.setEditable(true);
            MyTreeCellEditor editor = new MyTreeCellEditor(this.clipboardTree, (DefaultTreeCellRenderer)this.clipboardTree.getCellRenderer());
            this.clipboardTree.setCellEditor(editor);
            Core.getInstance().getClipboard().addClipboardListener((ClipboardListener)this);
        }
    }

    public JTree getAIBenchTree() {
        return this.sessionTree;
    }

    public JTree getAIBenchClipboardTree() {
        return this.clipboardTree;
    }

    public static AIBenchJTreeManager getInstance() {
        if (instance == null) {
            instance = new AIBenchJTreeManager();
        }
        return instance;
    }

    public DefaultMutableTreeNode createClipNode(ClipboardItem clipItem, DefaultMutableTreeNode parent, final boolean mapping) {
        DefaultMutableTreeNode toret = null;
        Datatype aibenchType = clipItem.getRegisteredUserClass().getAnnotation(Datatype.class);
        if (aibenchType != null && aibenchType.structure() != Structure.SIMPLE) {
            if (aibenchType.structure() == Structure.COMPLEX) {
                toret = this.createComplexClipboardNode(Core.getInstance().getClipboard().getComplexSubItems(clipItem), clipItem, mapping);
            } else if (aibenchType.structure() == Structure.LIST) {
                toret = this.createListClipboardNode(Core.getInstance().getClipboard().getListSubItems(clipItem), clipItem, mapping);
            }
        } else {
            toret = clipItem.getRegisteredUserClass().isArray() ? this.createArrayClipboardNode(clipItem, mapping) : this.createSimpleClipboardNode(clipItem, mapping);
        }
        if (parent != null) {
            parent.insert(toret, parent.getChildCount());
        }
        if (Boolean.parseBoolean(Core.CONFIG.getProperty("clipboard.listenobservables", "false")) && clipItem instanceof Observable) {
            if (logger.getEffectiveLevel().equals((Object)Level.DEBUG)) {
                logger.debug((Object)("tree: its observable " + clipItem));
            }
            class NodeObserver
            implements Observer {
                private DefaultMutableTreeNode node;
                private ClipboardItem item;

                public NodeObserver(DefaultMutableTreeNode node, ClipboardItem item) {
                    this.node = node;
                    this.item = item;
                }

                @Override
                public void update(final Observable o, Object arg) {
                    Runnable runnable = new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            if (logger.getEffectiveLevel().equals((Object)Level.DEBUG)) {
                                logger.debug((Object)("updating clipboarditem " + o));
                            }
                            if (item.getUserData() != null) {
                                Datatype annot = item.getUserData().getClass().getAnnotation(Datatype.class);
                                if (annot != null && (annot.structure() == Structure.COMPLEX || annot.structure() == Structure.LIST)) {
                                    for (int i = 0; i < node.getChildCount(); ++i) {
                                        ((DefaultTreeModel)AIBenchJTreeManager.this.sessionTree.getModel()).nodeChanged(node.getChildAt(i));
                                        ((DefaultTreeModel)AIBenchJTreeManager.this.clipboardTree.getModel()).nodeChanged(node.getChildAt(i));
                                    }
                                }
                                ((DefaultTreeModel)AIBenchJTreeManager.this.sessionTree.getModel()).nodeChanged(node);
                                ((DefaultTreeModel)AIBenchJTreeManager.this.clipboardTree.getModel()).nodeChanged(node);
                                Clipboard clipboard = Core.getInstance().getClipboard();
                                synchronized (clipboard) {
                                    boolean isComplexSubItem = false;
                                    List subItems = Core.getInstance().getClipboard().getComplexSubItems(item);
                                    if (subItems == null) {
                                        subItems = Core.getInstance().getClipboard().getArraySubItems(item);
                                    } else {
                                        isComplexSubItem = true;
                                    }
                                    if (subItems == null) {
                                        subItems = Core.getInstance().getClipboard().getListSubItems(item);
                                    }
                                    if (subItems == null) {
                                        return;
                                    }
                                    LinkedHashMap<Integer, DefaultMutableTreeNode> orderedNodes = new LinkedHashMap<Integer, DefaultMutableTreeNode>();
                                    ArrayList<DefaultMutableTreeNode> unorderedNodes = new ArrayList<DefaultMutableTreeNode>();
                                    int newNodes = 0;
                                    HashSet<DefaultMutableTreeNode> expandedCTree = new HashSet<DefaultMutableTreeNode>();
                                    HashSet<DefaultMutableTreeNode> expandedHTree = new HashSet<DefaultMutableTreeNode>();
                                    for (int i = 0; i < node.getChildCount(); ++i) {
                                        DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
                                        TreePath path = new TreePath(child.getPath());
                                        if (AIBenchJTreeManager.this.sessionTree.isExpanded(path)) {
                                            expandedHTree.add(child);
                                        } else if (AIBenchJTreeManager.this.clipboardTree.isExpanded(path)) {
                                            expandedCTree.add(child);
                                        }
                                        if (!(child.getUserObject() instanceof ClipboardItem)) continue;
                                        int childOrder = Core.getInstance().getClipboard().getOrder(((ClipboardItem)child.getUserObject()).getID());
                                        if (childOrder != -1) {
                                            orderedNodes.put(childOrder, child);
                                            continue;
                                        }
                                        unorderedNodes.add(child);
                                    }
                                    block5: for (ClipboardItem item : subItems) {
                                        for (int i = 0; i < node.getChildCount(); ++i) {
                                            DefaultMutableTreeNode _node = (DefaultMutableTreeNode)node.getChildAt(i);
                                            if (_node.getUserObject() == item) continue block5;
                                        }
                                        if (logger.getEffectiveLevel().equals((Object)Level.DEBUG)) {
                                            logger.debug((Object)("A complex item in the tree has a changed child! " + item));
                                        }
                                        if (isComplexSubItem && item.getUserData() == null && Boolean.parseBoolean(Workbench.CONFIG.getProperty("trees.shownulls", "false"))) continue;
                                        DefaultMutableTreeNode nodeNew = AIBenchJTreeManager.this.createClipNode(item, null, mapping);
                                        ++newNodes;
                                        int relativeOrder = Core.getInstance().getClipboard().getOrder(item.getID());
                                        if (logger.getEffectiveLevel().equals((Object)Level.DEBUG)) {
                                            logger.debug((Object)("trees: modifying " + item.getName() + "(id: " + item.getID() + ") with order=" + relativeOrder));
                                        }
                                        if (relativeOrder != -1) {
                                            orderedNodes.put(relativeOrder, nodeNew);
                                            continue;
                                        }
                                        unorderedNodes.add(nodeNew);
                                    }
                                    Object[] order = orderedNodes.keySet().toArray(new Integer[orderedNodes.keySet().size()]);
                                    Arrays.sort(order);
                                    int counter = node.getChildCount() - orderedNodes.size() - unorderedNodes.size() + newNodes;
                                    TreePath selectedPath = null;
                                    TreePath path = null;
                                    for (Object i : order) {
                                        DefaultMutableTreeNode orderedNode = (DefaultMutableTreeNode)orderedNodes.get(i);
                                        if (orderedNode.getParent() != null && orderedNode.getParent() == node) {
                                            ++counter;
                                            if (expandedHTree.contains(orderedNode)) {
                                                path = new TreePath(orderedNode.getPath());
                                                AIBenchJTreeManager.this.sessionTree.expandPath(path);
                                                continue;
                                            }
                                            if (!expandedCTree.contains(orderedNode)) continue;
                                            path = new TreePath(orderedNode.getPath());
                                            AIBenchJTreeManager.this.clipboardTree.expandPath(path);
                                            continue;
                                        }
                                        node.insert(orderedNode, counter++);
                                        selectedPath = new TreePath(orderedNode.getPath());
                                    }
                                    for (TreeNode treeNode : unorderedNodes) {
                                        DefaultMutableTreeNode unorderedNode = (DefaultMutableTreeNode)treeNode;
                                        if (unorderedNode.getParent() != null && unorderedNode.getParent() == node) {
                                            ++counter;
                                            if (expandedHTree.contains(unorderedNode)) {
                                                path = new TreePath(unorderedNode.getPath());
                                                AIBenchJTreeManager.this.sessionTree.expandPath(path);
                                                continue;
                                            }
                                            if (!expandedCTree.contains(unorderedNode)) continue;
                                            path = new TreePath(unorderedNode.getPath());
                                            AIBenchJTreeManager.this.clipboardTree.expandPath(path);
                                            continue;
                                        }
                                        node.insert(unorderedNode, counter++);
                                        selectedPath = new TreePath(unorderedNode.getPath());
                                    }
                                    if (selectedPath != null) {
                                        ((DefaultTreeModel)AIBenchJTreeManager.this.sessionTree.getModel()).nodeStructureChanged(node);
                                        ((DefaultTreeModel)AIBenchJTreeManager.this.clipboardTree.getModel()).nodeStructureChanged(node);
                                        AIBenchJTreeManager.this.sessionTree.expandPath(selectedPath);
                                        AIBenchJTreeManager.this.sessionTree.scrollPathToVisible(selectedPath);
                                        AIBenchJTreeManager.this.sessionTree.setSelectionPath(selectedPath);
                                        AIBenchJTreeManager.this.clipboardTree.expandPath(selectedPath);
                                        AIBenchJTreeManager.this.clipboardTree.scrollPathToVisible(selectedPath);
                                        AIBenchJTreeManager.this.clipboardTree.setSelectionPath(selectedPath);
                                    }
                                }
                            }
                        }
                    };
                    if (!SwingUtilities.isEventDispatchThread()) {
                        try {
                            SwingUtilities.invokeAndWait(runnable);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        catch (InvocationTargetException e) {
                            e.printStackTrace();
                        }
                    } else {
                        runnable.run();
                    }
                }
            }
            ((Observable)clipItem).addObserver(new NodeObserver(toret, clipItem));
        }
        return toret;
    }

    private DefaultMutableTreeNode createSimpleClipboardNode(ClipboardItem clipItem, boolean mapping) {
        DefaultMutableTreeNode toret = new DefaultMutableTreeNode(clipItem);
        if (mapping) {
            this.clipboardMapping.put(clipItem, toret);
        }
        return toret;
    }

    private DefaultMutableTreeNode createComplexClipboardNode(List<ClipboardItem> clipboardItems, final ClipboardItem clipItem, boolean mapping) {
        DefaultMutableTreeNode toret = this.createSimpleClipboardNode(clipItem, mapping);
        for (final Method m : clipItem.getUserData().getClass().getMethods()) {
            final Property property = m.getAnnotation(Property.class);
            if (property == null) continue;
            if (Boolean.parseBoolean(Core.CONFIG.getProperty("clipboard.listenobservables", "false"))) {
                Object propertyReader = new Object(){

                    public String toString() {
                        try {
                            if (!clipItem.wasRemoved()) {
                                return property.name() + (property.name() == null ? "" : ": ") + m.invoke(clipItem.getUserData(), (Object[])null);
                            }
                        }
                        catch (IllegalArgumentException e) {
                            e.printStackTrace();
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                        catch (InvocationTargetException e) {
                            e.printStackTrace();
                        }
                        return "";
                    }
                };
                toret.insert(new DefaultMutableTreeNode(propertyReader), toret.getChildCount());
                continue;
            }
            try {
                toret.insert(new DefaultMutableTreeNode(property.name() + (property.name() == null ? "" : ": ") + m.invoke(clipItem.getUserData(), (Object[])null)), toret.getChildCount());
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        for (ClipboardItem subItem : Core.getInstance().getClipboard().getComplexSubItems(clipItem)) {
            if (Boolean.parseBoolean(Workbench.CONFIG.getProperty("trees.shownulls", "true")) && subItem.getUserData() == null) continue;
            this.createClipNode(subItem, toret, mapping);
        }
        return toret;
    }

    private DefaultMutableTreeNode createListClipboardNode(List<ClipboardItem> clipboardItems, final ClipboardItem clipItem, boolean mapping) {
        DefaultMutableTreeNode toret = this.createSimpleClipboardNode(clipItem, mapping);
        for (final Method m : clipItem.getUserData().getClass().getMethods()) {
            final Property property = m.getAnnotation(Property.class);
            if (property == null) continue;
            Object propertyReader = new Object(){

                public String toString() {
                    try {
                        if (!clipItem.wasRemoved()) {
                            return property.name() + (property.name() == null ? "" : ": ") + m.invoke(clipItem.getUserData(), (Object[])null);
                        }
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                    return "";
                }
            };
            if (Core.CONFIG.getProperty("clipboard.listenobservables") != null && Core.CONFIG.getProperty("clipboard.listenobservables").equals("true")) {
                toret.insert(new DefaultMutableTreeNode(propertyReader), toret.getChildCount());
                continue;
            }
            try {
                toret.insert(new DefaultMutableTreeNode(property.name() + (property.name() == null ? "" : ": ") + m.invoke(clipItem.getUserData(), (Object[])null)), toret.getChildCount());
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        for (ClipboardItem subItem : Core.getInstance().getClipboard().getListSubItems(clipItem)) {
            this.createClipNode(subItem, toret, mapping);
        }
        return toret;
    }

    private DefaultMutableTreeNode createArrayClipboardNode(ClipboardItem clipItem, boolean mapping) {
        DefaultMutableTreeNode toret = this.createSimpleClipboardNode(clipItem, mapping);
        for (ClipboardItem subItem : Core.getInstance().getClipboard().getArraySubItems(clipItem)) {
            this.createClipNode(subItem, toret, mapping);
        }
        return toret;
    }

    public void historyElementAdded(final HistoryElement history) {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HistoryElement historyElement = history;
                synchronized (historyElement) {
                    DefaultMutableTreeNode operationNode = new DefaultMutableTreeNode(history);
                    for (Object result : history.getOutputs()) {
                        Clipboard clipboard = Core.getInstance().getClipboard();
                        synchronized (clipboard) {
                            for (ClipboardItem rootItem : Core.getInstance().getClipboard().getRootItems()) {
                                if (rootItem.getUserData() != result) continue;
                                for (ClipboardItem resultItem : history.getClipboardItems()) {
                                    if (rootItem != resultItem) continue;
                                    AIBenchJTreeManager.this.createClipNode(rootItem, operationNode, true);
                                }
                            }
                        }
                    }
                    boolean insertedAnywhere = false;
                    Vector<ClipboardItem> noRepeat = new Vector<ClipboardItem>();
                    DefaultTreeModel model = (DefaultTreeModel)AIBenchJTreeManager.this.sessionTree.getModel();
                    for (ParamSpec spec : history.getParams()) {
                        if (spec.getSource() == ParamSource.CLIPBOARD) {
                            ClipboardItem item = (ClipboardItem)spec.getValue();
                            if (noRepeat.indexOf(item) != -1) continue;
                            noRepeat.addElement(item);
                            MutableTreeNode node = (MutableTreeNode)AIBenchJTreeManager.this.clipboardMapping.get(item);
                            if (node == null) continue;
                            try {
                                model.insertNodeInto(operationNode, node, node.getChildCount());
                            }
                            catch (IllegalArgumentException e) {
                                e.printStackTrace();
                                operationNode.remove(node);
                                model.insertNodeInto(operationNode, node, node.getChildCount());
                            }
                            insertedAnywhere = true;
                            continue;
                        }
                        DefaultMutableTreeNode paramNode = new DefaultMutableTreeNode(spec.getName() + ": " + spec.getRawValue());
                        model.insertNodeInto(paramNode, operationNode, 0);
                    }
                    if (!insertedAnywhere) {
                        model.insertNodeInto(operationNode, (MutableTreeNode)model.getRoot(), ((MutableTreeNode)model.getRoot()).getChildCount());
                    }
                    AIBenchJTreeManager.this.sessionTree.expandPath(new TreePath(operationNode.getPath()));
                    AIBenchJTreeManager.this.sessionTree.scrollPathToVisible(new TreePath(operationNode.getPath()));
                    AIBenchJTreeManager.this.sessionTree.setSelectionPath(new TreePath(operationNode.getPath()));
                }
            }
        });
    }

    private static final ClassTreeNode locateClassNode(JTree tree, Class<?> clazz) {
        TreeModel model = tree.getModel();
        if (model == null || model.getRoot() == null) {
            return null;
        }
        for (int i = 0; i < model.getChildCount(model.getRoot()); ++i) {
            Object node = model.getChild(model.getRoot(), i);
            if (!(node instanceof ClassTreeNode)) continue;
            ClassTreeNode classNode = (ClassTreeNode)node;
            if (!classNode.clazz.equals(clazz)) continue;
            return classNode;
        }
        return null;
    }

    private void clipboardTreeElementAdded(ClipboardItem item) {
        if (logger.getEffectiveLevel().equals((Object)Level.DEBUG)) {
            logger.debug((Object)("Adding clipboard item " + item.getName()));
        }
        DefaultTreeModel cTreeModel = (DefaultTreeModel)this.clipboardTree.getModel();
        MutableTreeNode cRootNode = (MutableTreeNode)cTreeModel.getRoot();
        for (ClipboardItem item2 : Core.getInstance().getClipboard().getRootItems()) {
            if (item2 != item) continue;
            DefaultMutableTreeNode newNode = this.createClipNode(item, null, false);
            if (newNode != null) {
                DefaultMutableTreeNode parentNode = null;
                if (Boolean.parseBoolean(Workbench.CONFIG.getProperty("clipboardtree.organizebyclass", "true"))) {
                    parentNode = AIBenchJTreeManager.locateClassNode(this.clipboardTree, item.getUserData().getClass());
                    if (parentNode == null) {
                        int order;
                        String name = item.getUserData().getClass().getSimpleName();
                        Datatype datatypeAnnot = item.getUserData().getClass().getAnnotation(Datatype.class);
                        if (datatypeAnnot != null && !datatypeAnnot.clipboardClassName().equals("")) {
                            name = datatypeAnnot.clipboardClassName();
                        }
                        parentNode = new ClassTreeNode(name, item.getUserData().getClass());
                        for (order = 0; order < cRootNode.getChildCount() && name.compareTo(cRootNode.getChildAt(order).toString()) > 0; ++order) {
                        }
                        cTreeModel.insertNodeInto(parentNode, cRootNode, order);
                    }
                } else {
                    parentNode = (DefaultMutableTreeNode)cTreeModel.getRoot();
                }
                if (parentNode != null) {
                    cTreeModel.insertNodeInto(newNode, parentNode, parentNode.getChildCount());
                    this.clipboardTree.expandPath(new TreePath(newNode.getPath()));
                    this.clipboardTree.scrollPathToVisible(new TreePath(newNode.getPath()));
                    this.clipboardTree.setSelectionPath(new TreePath(newNode.getPath()));
                }
            }
            return;
        }
    }

    public synchronized void elementAdded(final ClipboardItem item) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AIBenchJTreeManager.this.clipboardTreeElementAdded(item);
            }
        });
    }

    public void elementLoaded(File f) {
    }

    public DefaultMutableTreeNode findNodeForUserObject(Object item, JTree tree) {
        return this.findNodeForUserObject(tree.getModel().getRoot(), item, tree);
    }

    private DefaultMutableTreeNode findNodeForUserObject(Object parent, Object item, JTree tree) {
        if (parent == null) {
            return null;
        }
        if (((DefaultMutableTreeNode)parent).getUserObject().equals(item)) {
            return (DefaultMutableTreeNode)parent;
        }
        for (int i = 0; i < tree.getModel().getChildCount(parent); ++i) {
            DefaultMutableTreeNode search = this.findNodeForUserObject(tree.getModel().getChild(parent, i), item, tree);
            if (search == null) continue;
            return search;
        }
        return null;
    }

    public void elementRemoved(final ClipboardItem item) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DefaultMutableTreeNode node;
                MutableTreeNode rootNode = (MutableTreeNode)AIBenchJTreeManager.this.sessionTree.getModel().getRoot();
                if (logger.getEffectiveLevel().equals((Object)Level.DEBUG)) {
                    logger.debug((Object)("Tree removing item: " + item));
                }
                if ((node = AIBenchJTreeManager.this.findNodeForUserObject(item, AIBenchJTreeManager.this.sessionTree)) != null) {
                    ((DefaultTreeModel)AIBenchJTreeManager.this.sessionTree.getModel()).removeNodeFromParent(node);
                    node.setUserObject("");
                    for (int i = 0; i < node.getChildCount(); ++i) {
                        DefaultMutableTreeNode nodeChild = (DefaultMutableTreeNode)node.getChildAt(i);
                        if (!(nodeChild.getUserObject() instanceof HistoryElement)) continue;
                        if (logger.getEffectiveLevel().equals((Object)Level.DEBUG)) {
                            logger.debug((Object)"This clipboard has a child operation. moved it to root");
                        }
                        nodeChild.removeFromParent();
                        ((DefaultTreeModel)AIBenchJTreeManager.this.sessionTree.getModel()).insertNodeInto(nodeChild, rootNode, rootNode.getChildCount());
                    }
                }
                if ((node = AIBenchJTreeManager.this.findNodeForUserObject(item, AIBenchJTreeManager.this.clipboardTree)) != null) {
                    if (node.getParent() instanceof ClassTreeNode && node.getParent().getChildCount() == 1) {
                        ClassTreeNode classNode = AIBenchJTreeManager.locateClassNode(AIBenchJTreeManager.this.clipboardTree, item.getRegisteredUserClass());
                        if (classNode != null) {
                            ((DefaultTreeModel)AIBenchJTreeManager.this.clipboardTree.getModel()).removeNodeFromParent(classNode);
                        }
                    } else {
                        ((DefaultTreeModel)AIBenchJTreeManager.this.clipboardTree.getModel()).removeNodeFromParent(node);
                    }
                    node.setUserObject("");
                }
                AIBenchJTreeManager.this.clipboardMapping.remove(item);
            }
        });
    }

    public void historyElementRemoved(final HistoryElement history) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DefaultMutableTreeNode node;
                if (logger.getEffectiveLevel().equals((Object)Level.DEBUG)) {
                    logger.debug((Object)("Tree removing history: " + history));
                }
                if ((node = AIBenchJTreeManager.this.findNodeForUserObject(history, AIBenchJTreeManager.this.sessionTree)) != null) {
                    ((DefaultTreeModel)AIBenchJTreeManager.this.sessionTree.getModel()).removeNodeFromParent(node);
                    node.setUserObject("");
                }
            }
        });
    }

    public static final class ClassTreeNode
    extends DefaultMutableTreeNode {
        private static final long serialVersionUID = 1L;
        public final Class<?> clazz;

        public ClassTreeNode(String name, Class<?> clazz) {
            super(name);
            this.clazz = clazz;
        }
    }

    class MyTreeCellEditor
    extends DefaultTreeCellEditor {
        private Object lastEditingObject;

        public MyTreeCellEditor(JTree tree, DefaultTreeCellRenderer renderer) {
            super(tree, renderer);
            this.lastEditingObject = null;
            tree.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    MyTreeCellEditor.this.lastEditingObject = null;
                }
            });
            this.addCellEditorListener(new CellEditorListener(){

                @Override
                public void editingCanceled(ChangeEvent e) {
                }

                @Override
                public void editingStopped(ChangeEvent e) {
                    if (MyTreeCellEditor.this.lastEditingObject != null && MyTreeCellEditor.this.lastEditingObject instanceof ClipboardItem) {
                        ClipboardItem item = (ClipboardItem)MyTreeCellEditor.this.lastEditingObject;
                        item.setName(MyTreeCellEditor.this.getCellEditorValue().toString());
                        Datatype datatypeAnnot = item.getUserData().getClass().getAnnotation(Datatype.class);
                        if (datatypeAnnot != null && !datatypeAnnot.setNameMethod().equals("")) {
                            try {
                                Method m = item.getUserData().getClass().getMethod(datatypeAnnot.setNameMethod(), String.class);
                                m.invoke(item.getUserData(), MyTreeCellEditor.this.getCellEditorValue().toString());
                            }
                            catch (SecurityException f) {
                                f.printStackTrace();
                            }
                            catch (NoSuchMethodException f) {
                                logger.error((Object)("Couldn't find the set name method in the Complex item " + item.getUserData().getClass() + ":  " + datatypeAnnot.setNameMethod()));
                            }
                            catch (IllegalArgumentException f) {
                                f.printStackTrace();
                            }
                            catch (IllegalAccessException f) {
                                f.printStackTrace();
                            }
                            catch (InvocationTargetException f) {
                                f.printStackTrace();
                            }
                        }
                        TreePath selPath = MyTreeCellEditor.this.tree.getSelectionPath();
                        MyTreeCellEditor.this.tree.setSelectionPath(selPath);
                        if (selPath != null) {
                            DefaultMutableTreeNode node = (DefaultMutableTreeNode)selPath.getLastPathComponent();
                            node.setUserObject(MyTreeCellEditor.this.lastEditingObject);
                        }
                        JTree clipboardTree = Workbench.getInstance().getTreeManager().getAIBenchClipboardTree();
                        DefaultMutableTreeNode _node = Workbench.getInstance().getTreeManager().findNodeForUserObject(item, clipboardTree);
                        ((DefaultTreeModel)clipboardTree.getModel()).nodeChanged(_node);
                        JTree sessionTree = Workbench.getInstance().getTreeManager().getAIBenchTree();
                        _node = Workbench.getInstance().getTreeManager().findNodeForUserObject(item, sessionTree);
                        ((DefaultTreeModel)sessionTree.getModel()).nodeChanged(_node);
                    }
                    MyTreeCellEditor.this.lastEditingObject = null;
                }
            });
        }

        @Override
        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
            Component comp = super.getTreeCellEditorComponent(tree, value, isSelected, expanded, leaf, row);
            this.editingIcon = ((JLabel)this.renderer.getTreeCellRendererComponent(tree, value, true, expanded, leaf, row, true)).getIcon();
            return comp;
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            if (this.lastEditingObject != null) {
                return false;
            }
            if (anEvent == null) {
                TreePath selPath = this.tree.getSelectionPath();
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)selPath.getLastPathComponent();
                if (node.getUserObject() instanceof ClipboardItem) {
                    ClipboardItem citem = (ClipboardItem)node.getUserObject();
                    Datatype datatypeAnnot = citem.getUserData().getClass().getAnnotation(Datatype.class);
                    return datatypeAnnot == null || datatypeAnnot.renameable();
                }
            } else if (anEvent != null && anEvent instanceof MouseEvent) {
                if (((MouseEvent)anEvent).isPopupTrigger()) {
                    return false;
                }
                TreePath selPath = this.tree.getPathForLocation(((MouseEvent)anEvent).getPoint().x, ((MouseEvent)anEvent).getPoint().y);
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)selPath.getLastPathComponent();
                if (node.getUserObject() instanceof ClipboardItem) {
                    ClipboardItem citem = (ClipboardItem)node.getUserObject();
                    Datatype datatypeAnnot = citem.getUserData().getClass().getAnnotation(Datatype.class);
                    if (logger.getEffectiveLevel().equals((Object)Level.DEBUG)) {
                        logger.debug((Object)("annotation: " + datatypeAnnot));
                    }
                    if (datatypeAnnot != null && !datatypeAnnot.renameable()) {
                        return false;
                    }
                    return selPath.equals(this.tree.getSelectionPath());
                }
            }
            return false;
        }

        @Override
        protected void prepareForEditing() {
            DefaultMutableTreeNode node;
            super.prepareForEditing();
            TreePath selPath = this.tree.getSelectionPath();
            if (selPath != null && (node = (DefaultMutableTreeNode)selPath.getLastPathComponent()).getUserObject() instanceof ClipboardItem) {
                this.lastEditingObject = node.getUserObject();
            }
        }
    }
}

