/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.aibench.workbench.inputgui;

import es.uvigo.ei.aibench.core.ParamSource;
import es.uvigo.ei.aibench.core.ParamSpec;
import es.uvigo.ei.aibench.core.operation.annotation.Port;
import es.uvigo.ei.aibench.workbench.ParamsReceiver;
import es.uvigo.ei.aibench.workbench.Workbench;
import es.uvigo.ei.aibench.workbench.inputgui.AbstractParamProvider;
import es.uvigo.ei.aibench.workbench.inputgui.Common;
import es.uvigo.ei.aibench.workbench.utilities.FileDrop;
import es.uvigo.ei.aibench.workbench.utilities.PortExtras;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class FileParamProvider
extends AbstractParamProvider {
    private static final Logger LOGGER = Logger.getLogger(FileParamProvider.class);
    private final JTextField field = new JTextField();
    private final JButton findButton = new JButton(Common.ICON_FILE_OPEN);
    private final FileChooserConfiguration fcConfiguration;
    public static final boolean DEFAULT_CASE_SENSITIVE = true;
    public static final String CASE_SENSITIVE_FILTERS_EXTRAS_PROPERTY = "caseSensitiveFilters";
    public static final String FILTERS_EXTRAS_PROPERTY = "filters";
    public static final String FILTERS_EXTRAS_ALLOWALL_FILTER = "allowAll";
    public static final String FILTERS_EXTRAS_SELECTION_MODE = "selectionMode";
    private static final String SELECTION_MODE_FILES_AND_DIRECTORIES = "filesAndDirectories";
    private static final String SELECTION_MODE_DIRECTORIES = "directories";
    private static final String SELECTION_MODE_FILES = "files";
    private static final String[] KNOWN_PROPERTIES = new String[]{"caseSensitiveFilters", "filters", "selectionMode"};
    private JComponent component = null;
    private FileFilter lastFileFilter = null;

    public FileParamProvider(ParamsReceiver receiver, Port p, Class<?> clazz, Object operationObject) {
        super(receiver, p, clazz, operationObject);
        this.fcConfiguration = new FileChooserConfiguration(p.extras());
        this.initComponent(p);
    }

    private void initComponent(Port p) {
        this.field.setEditable(false);
        if (p.defaultValue().length() > 0) {
            this.field.setText(p.defaultValue());
        }
    }

    public static void configureFileChooser(Port p, JFileChooser fc) {
        FileChooserConfiguration.configure(p.extras(), fc);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.findButton) {
            this.showFileChooser();
        }
        super.actionPerformed(e);
    }

    private void showFileChooser() {
        JFileChooser fileChooser = Common.SINGLE_FILE_CHOOSER;
        this.fcConfiguration.configureFileChooser(fileChooser);
        FileParamProvider.configureLastFileFilter(fileChooser, this.lastFileFilter);
        File selectedFile = this.getSelectedFile();
        if (selectedFile != null) {
            fileChooser.setSelectedFile(selectedFile);
        }
        int option = fileChooser.showDialog(Workbench.getInstance().getMainFrame(), "Select");
        this.lastFileFilter = fileChooser.getFileFilter();
        if (option == 0) {
            this.setSelectedFile(fileChooser.getSelectedFile());
        }
    }

    private static void configureLastFileFilter(JFileChooser fileChooser, FileFilter lastFileFilter) {
        if (lastFileFilter != null) {
            fileChooser.setFileFilter(lastFileFilter);
        }
    }

    private File getSelectedFile() {
        String text = this.field.getText().trim();
        return text.isEmpty() ? null : new File(text);
    }

    public void setSelectedFile(File file) {
        if (file == null) {
            this.field.setText("");
        } else {
            this.field.setText(file.getAbsolutePath());
        }
        this.setChanged();
        this.notifyObservers();
    }

    public JTextField getField() {
        return this.field;
    }

    @Override
    public JComponent getComponent() {
        if (this.component == null) {
            this.component = new JPanel();
            this.component.setLayout(new BorderLayout());
            this.field.setPreferredSize(new Dimension(150, this.field.getPreferredSize().height));
            this.findButton.setToolTipText("Browse the local filesystem to select a file");
            this.component.add((Component)this.field, "Center");
            this.component.add((Component)this.findButton, "East");
            new FileDrop(this.field, new FileDrop.Listener(){

                @Override
                public void filesDropped(File[] files) {
                    if (files.length > 0) {
                        FileParamProvider.this.setSelectedFile(files[0]);
                    }
                }
            });
            this.field.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    FileParamProvider.this.showFileChooser();
                }
            });
            this.findButton.addActionListener(this);
        }
        return this.component;
    }

    @Override
    public ParamSpec getParamSpec() {
        File selectedFile = this.getSelectedFile();
        if (selectedFile == null) {
            return new ParamSpec(this.port.name(), this.clazz, null, ParamSource.CLIPBOARD);
        }
        return new ParamSpec(this.port.name(), this.clazz, (Object)selectedFile.getAbsolutePath(), ParamSource.STRING_CONSTRUCTOR);
    }

    @Override
    public boolean isValidValue() {
        return this.port.allowNull() || this.getSelectedFile() != null;
    }

    private static class FileChooserConfiguration {
        public static final String FILE_FILTERS_DELIMITER = ";";
        public static final String FILE_FILTERS_ASSIGNMENT = ":";
        private final List<ExtensionFileFilter> filters = new ArrayList<ExtensionFileFilter>();
        private int selectionMode = 2;
        private boolean allowAll = true;

        public static void configure(String configuration, JFileChooser fc) {
            new FileChooserConfiguration(configuration).configureFileChooser(fc);
        }

        public FileChooserConfiguration(String configuration) {
            this.parseConfiguration(configuration);
        }

        private void parseConfiguration(String configuration) {
            PortExtras extras = PortExtras.parse(configuration);
            boolean caseSensitive = true;
            if (extras.containsProperty(FileParamProvider.CASE_SENSITIVE_FILTERS_EXTRAS_PROPERTY)) {
                caseSensitive = this.parseCaseSensitiveFilter(extras.getPropertyValue(FileParamProvider.CASE_SENSITIVE_FILTERS_EXTRAS_PROPERTY));
            }
            if (extras.containsProperty(FileParamProvider.FILTERS_EXTRAS_PROPERTY)) {
                this.parseFilters(extras.getPropertyValue(FileParamProvider.FILTERS_EXTRAS_PROPERTY), caseSensitive);
            }
            if (extras.containsProperty(FileParamProvider.FILTERS_EXTRAS_SELECTION_MODE)) {
                this.parseSelectionMode(extras.getPropertyValue(FileParamProvider.FILTERS_EXTRAS_SELECTION_MODE));
            }
            PortExtras.warnUnknownExtraProperties(extras, LOGGER, true, KNOWN_PROPERTIES);
        }

        private boolean parseCaseSensitiveFilter(String caseSensitiveValue) {
            if (caseSensitiveValue.equalsIgnoreCase("false")) {
                return false;
            }
            if (caseSensitiveValue.equalsIgnoreCase("true")) {
                return true;
            }
            LOGGER.warn((Object)"Invalid value for property: caseSensitiveFilters");
            return true;
        }

        private void parseFilters(String value, boolean caseSensitive) {
            String[] filters;
            this.allowAll = false;
            for (String filter : filters = value.split(FILE_FILTERS_DELIMITER)) {
                String nameExtension;
                String[] nameExpAndDesc = filter.trim().split(FILE_FILTERS_ASSIGNMENT);
                if (nameExpAndDesc.length == 2) {
                    nameExtension = nameExpAndDesc[0].trim();
                    String description = nameExpAndDesc[1].trim();
                    this.filters.add(new ExtensionFileFilter(nameExtension, description, caseSensitive));
                    continue;
                }
                if (nameExpAndDesc.length == 1) {
                    nameExtension = nameExpAndDesc[0].trim();
                    if (FileParamProvider.FILTERS_EXTRAS_ALLOWALL_FILTER.equalsIgnoreCase(nameExtension)) {
                        this.allowAll = true;
                        continue;
                    }
                    LOGGER.warn((Object)("Unable to parse a filter in extras: " + filter));
                    continue;
                }
                LOGGER.warn((Object)("Unable to parse a filter in extras: " + filter));
            }
        }

        private void parseSelectionMode(String value) {
            if (FileParamProvider.SELECTION_MODE_FILES.equalsIgnoreCase(value)) {
                this.selectionMode = 0;
            } else if (FileParamProvider.SELECTION_MODE_DIRECTORIES.equalsIgnoreCase(value)) {
                this.selectionMode = 1;
            } else if (FileParamProvider.SELECTION_MODE_FILES_AND_DIRECTORIES.equalsIgnoreCase(value)) {
                this.selectionMode = 2;
            } else {
                LOGGER.warn((Object)("Unknown value for selectionMode filter: " + value));
                this.selectionMode = 2;
            }
        }

        public void configureFileChooser(JFileChooser fc) {
            File selectedFile = fc.getSelectedFile();
            fc.setSelectedFile(null);
            fc.setAcceptAllFileFilterUsed(false);
            fc.setFileSelectionMode(this.selectionMode);
            fc.resetChoosableFileFilters();
            for (ExtensionFileFilter filter : this.filters) {
                fc.addChoosableFileFilter(filter);
            }
            fc.setAcceptAllFileFilterUsed(this.allowAll);
            fc.setSelectedFile(selectedFile);
        }
    }

    private static class ExtensionFileFilter
    extends FileFilter {
        private final String nameregexp;
        private final String description;
        private boolean caseSensitive;

        public ExtensionFileFilter(String nameregexp, String desc, boolean caseSensitive) {
            this.nameregexp = nameregexp;
            this.description = desc;
            this.caseSensitive = caseSensitive;
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory() || pathname.getName().matches(this.getRegex());
        }

        private String getRegex() {
            return this.caseSensitive ? this.nameregexp : "(?i)" + this.nameregexp;
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }
}

