/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.gc4s.input;

import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JOptionPane;

public class JColorChooserButton
extends JButton {
    private static final long serialVersionUID = 1L;
    private static final Color DEFAULT_COLOR = Color.BLUE;
    private Color currentColor;

    public JColorChooserButton() {
        this(DEFAULT_COLOR);
    }

    public JColorChooserButton(Color color) {
        this.currentColor = color;
        this.init();
    }

    private void init() {
        this.setBackground(this.currentColor);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JColorChooserButton.this.showDialog();
            }
        });
    }

    private void showDialog() {
        JColorChooser colorChooser = this.getColorChooser();
        int response = JOptionPane.showConfirmDialog(this.getParent(), colorChooser, "Choose a color", 0);
        if (response == 0) {
            this.updateCurrentColor(colorChooser.getSelectionModel().getSelectedColor());
        }
    }

    private JColorChooser getColorChooser() {
        return new JColorChooser(this.currentColor);
    }

    public void setColor(Color color) {
        this.updateCurrentColor(color);
    }

    private void updateCurrentColor(Color newColor) {
        this.currentColor = newColor;
        this.setBackground(this.currentColor);
    }

    public Color getColor() {
        return this.currentColor;
    }
}

