/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.gc4s.filechooser;

import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.sing_group.gc4s.filechooser.JFileChooserPanel;

public class JFileChooserPanelBuilder {
    private JFileChooserPanel.Mode mode;
    private JFileChooser fileChooser = new JFileChooser();
    private ImageIcon browseIcon = JFileChooserPanel.DEFAULT_ICON_BROWSE;
    private String labelFileText = "File: ";
    private String requiredSaveFileExtension;
    private JFileChooserPanel.SelectionMode selectionMode = JFileChooserPanel.DEFAULT_SELECTION_MODE;
    private boolean allowAllFilter = true;
    private List<FileFilter> fileFilters = JFileChooserPanel.DEFAULT_FILE_FILTERS;

    public static JFileChooserPanelBuilder createOpenJFileChooserPanel() {
        return new JFileChooserPanelBuilder(JFileChooserPanel.Mode.OPEN);
    }

    public static JFileChooserPanelBuilder createSaveJFileChooserPanel() {
        return new JFileChooserPanelBuilder(JFileChooserPanel.Mode.SAVE);
    }

    protected JFileChooserPanelBuilder(JFileChooserPanel.Mode mode) {
        this.mode = mode;
    }

    public JFileChooserPanelBuilder withFileChooser(JFileChooser fileChooser) {
        this.fileChooser = fileChooser;
        return this;
    }

    public JFileChooserPanelBuilder withBrowseIcon(ImageIcon browseIcon) {
        this.browseIcon = browseIcon;
        return this;
    }

    public JFileChooserPanelBuilder withLabel(String labelFileText) {
        this.labelFileText = labelFileText;
        return this;
    }

    public JFileChooserPanelBuilder withRequiredFileSaveExtension(String requiredSaveFileExtension) {
        this.requiredSaveFileExtension = requiredSaveFileExtension;
        return this;
    }

    public JFileChooserPanelBuilder withFileChooserSelectionMode(JFileChooserPanel.SelectionMode selectionMode) {
        this.selectionMode = selectionMode;
        return this;
    }

    public JFileChooserPanelBuilder withAllowAllFilter(boolean allowAllFilter) {
        this.allowAllFilter = allowAllFilter;
        return this;
    }

    public JFileChooserPanelBuilder withFileFilters(List<FileFilter> fileFilters) {
        this.fileFilters = fileFilters;
        return this;
    }

    public JFileChooserPanel build() {
        return new JFileChooserPanel(this.mode, this.fileChooser, this.browseIcon, this.labelFileText, this.requiredSaveFileExtension, this.selectionMode, this.allowAllFilter, this.fileFilters);
    }
}

