/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.gc4s.dialog;

import java.awt.BorderLayout;
import java.awt.Window;
import java.io.InvalidClassException;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.sing_group.gc4s.dialog.AbstractInputJDialog;
import org.sing_group.gc4s.list.ExtendedDefaultListModel;
import org.sing_group.gc4s.list.JParallelListsPanel;

public class ListSelectionDialog<E>
extends AbstractInputJDialog {
    private static final long serialVersionUID = 1L;
    private static final String SELECTED_ITEMS = "Selected items";
    private static final String UNSELECTED_ITEMS = "Unselected items";
    private JPanel inputComponents;
    private List<E> selected;
    private String selectedItemsTitle;
    private ExtendedDefaultListModel<E> selectedListModel;
    private List<E> unselected;
    private String unselectedItemsTitle;
    private ExtendedDefaultListModel<E> unselectedListModel;

    public ListSelectionDialog(Window parent, List<E> selected, List<E> unselected) throws InvalidClassException {
        this(parent, selected, unselected, SELECTED_ITEMS, UNSELECTED_ITEMS);
    }

    public ListSelectionDialog(Window parent, List<E> selected, List<E> unselected, String selectedItemsTitle, String unselectedItemsTitle) throws InvalidClassException {
        super(parent);
        this.selected = selected;
        this.unselected = unselected;
        this.selectedItemsTitle = selectedItemsTitle;
        this.unselectedItemsTitle = unselectedItemsTitle;
        this.init();
    }

    private void init() throws InvalidClassException {
        this.unselectedListModel = new ExtendedDefaultListModel();
        this.unselectedListModel.addElements(this.unselected);
        JList<E> unselectedList = new JList<E>(this.unselectedListModel);
        unselectedList.setFixedCellWidth(200);
        this.selectedListModel = new ExtendedDefaultListModel();
        this.selectedListModel.addElements(this.selected);
        JList<E> selectedList = new JList<E>(this.selectedListModel);
        selectedList.setFixedCellWidth(200);
        JParallelListsPanel<E> parallelLists = new JParallelListsPanel<E>(unselectedList, selectedList, this.unselectedItemsTitle, this.selectedItemsTitle, false, false);
        this.inputComponents.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.inputComponents.add(parallelLists, "Center");
    }

    @Override
    protected String getDialogTitle() {
        return "Item selection";
    }

    @Override
    protected String getDescription() {
        return "This dialog allows you to select items";
    }

    @Override
    protected JPanel getInputComponentsPane() {
        this.inputComponents = new JPanel(new BorderLayout());
        return this.inputComponents;
    }

    @Override
    public void setVisible(boolean b) {
        this.okButton.setEnabled(true);
        this.pack();
        super.setVisible(b);
    }

    public List<E> getSelectedItems() {
        return this.extractElements(this.selectedListModel);
    }

    public List<E> getUnselectedItems() {
        return this.extractElements(this.unselectedListModel);
    }

    private List<E> extractElements(DefaultListModel<E> listModel) {
        Enumeration<E> iterator = listModel.elements();
        LinkedList<E> toret = new LinkedList<E>();
        while (iterator.hasMoreElements()) {
            toret.add(iterator.nextElement());
        }
        return toret;
    }
}

