/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.s2p.gui.quantification;

import es.uvigo.ei.sing.s2p.core.entities.quantification.QuantificationDataset;
import es.uvigo.ei.sing.s2p.core.operations.quantification.comparison.ComparisonMode;
import es.uvigo.ei.sing.s2p.gui.UISettings;
import es.uvigo.ei.sing.s2p.gui.components.ExtendedJTabbedPane;
import es.uvigo.ei.sing.s2p.gui.quantification.QuantificationReplicatesByProteinTable;
import es.uvigo.ei.sing.s2p.gui.quantification.QuantificationReplicatesTable;
import es.uvigo.ei.sing.s2p.gui.quantification.QuantificationTable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.sing_group.gc4s.ui.icons.Icons;
import org.sing_group.gc4s.visualization.ColorLegend;

public class QuantificationDatasetViewer
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String STATISTICAL_TESTS_MESSAGE = "Condition comparison columns show both p-value and corrected p-value (or q-value) of the t-test between %s values in each condition. Correction of p-values is performed by applying the Benjamini-Hochberg FDR procedure.";
    private QuantificationDataset dataset;
    private ExtendedJTabbedPane tabbedPane;
    private QuantificationTable quantificationTable;
    private QuantificationReplicatesTable quantificationReplicatesTable;
    private QuantificationReplicatesByProteinTable quantificationReplicatesByProteinTable;
    private ComparisonMode comparisonMode;

    public QuantificationDatasetViewer(QuantificationDataset dataset, ComparisonMode comparisonMode) {
        this.dataset = dataset;
        this.comparisonMode = comparisonMode;
        this.initComponent();
    }

    private void initComponent() {
        this.setLayout(new BorderLayout());
        this.setBackground(UISettings.BG_COLOR);
        this.add(this.getTabbedPane(), "Center");
        this.add(this.getSouthPane(), "South");
    }

    private Component getTabbedPane() {
        this.tabbedPane = new ExtendedJTabbedPane();
        this.tabbedPane.setHideTabBarWhenSingleTab(true);
        this.addTabs();
        return this.tabbedPane;
    }

    private void addTabs() {
        this.addQuantificationReplicatesTable();
        this.addQuantificationReplicatesByProteinTable();
        this.addQuantificationTable();
    }

    private void addQuantificationReplicatesTable() {
        this.tabbedPane.addTab("", this.getQuantificationReplicatesTable());
        this.tabbedPane.setTabComponentAt(0, QuantificationDatasetViewer.label("Replicates", Icons.ICON_TABLE_24));
    }

    private Component getQuantificationReplicatesTable() {
        this.quantificationReplicatesTable = new QuantificationReplicatesTable(this.dataset);
        return new JScrollPane((Component)((Object)this.quantificationReplicatesTable));
    }

    private static Component label(String string, ImageIcon icon) {
        JLabel toret = new JLabel(string);
        toret.setIcon(icon);
        toret.setIconTextGap(5);
        return toret;
    }

    private void addQuantificationReplicatesByProteinTable() {
        this.tabbedPane.addTab("", this.getQuantificationReplicatesByProteinTable());
        this.tabbedPane.setTabComponentAt(1, QuantificationDatasetViewer.label("Replicates (by protein)", Icons.ICON_TABLE_24));
    }

    private Component getQuantificationReplicatesByProteinTable() {
        this.quantificationReplicatesByProteinTable = new QuantificationReplicatesByProteinTable(this.dataset);
        return new JScrollPane((Component)((Object)this.quantificationReplicatesByProteinTable));
    }

    private void addQuantificationTable() {
        this.tabbedPane.addTab("", this.getQuantificationTable());
        this.tabbedPane.setTabComponentAt(2, QuantificationDatasetViewer.label("Conditions", Icons.ICON_TABLE_24));
    }

    private Component getQuantificationTable() {
        this.quantificationTable = new QuantificationTable(this.dataset, this.comparisonMode.getTest());
        return new JScrollPane((Component)((Object)this.quantificationTable));
    }

    private Component getSouthPane() {
        JPanel pane = new JPanel(new BorderLayout());
        pane.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        pane.setOpaque(true);
        pane.setBackground(UISettings.BG_COLOR);
        pane.add(this.getStatisticalTetsMessage(), "Center");
        pane.add(this.getColorLegend(), "East");
        return pane;
    }

    private Component getStatisticalTetsMessage() {
        JTextArea toret = new JTextArea();
        toret.setEditable(false);
        toret.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2), "Note"));
        toret.setLineWrap(true);
        toret.setWrapStyleWord(true);
        toret.setRows(2);
        toret.setText(this.getStatisticalTestsMessage());
        return toret;
    }

    private Component getColorLegend() {
        ColorLegend colorLegend = new ColorLegend(this.getConditionColorMap());
        colorLegend.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2), "Color legend"));
        colorLegend.setBackground(UISettings.BG_COLOR);
        return colorLegend;
    }

    private Map<String, Color> getConditionColorMap() {
        HashMap<String, Color> conditionToColor = new HashMap<String, Color>();
        this.quantificationTable.getConditionColors().forEach((condition, color) -> conditionToColor.put(condition.getName(), (Color)color));
        return conditionToColor;
    }

    private String getStatisticalTestsMessage() {
        return String.format(STATISTICAL_TESTS_MESSAGE, this.comparisonMode.getLabel());
    }
}

