/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.aibench.core.operation.execution;

import es.uvigo.ei.aibench.core.operation.execution.AbstractExecutable;
import es.uvigo.ei.aibench.core.operation.execution.CollectorAdapterFactory;
import es.uvigo.ei.aibench.core.operation.execution.Executable;
import es.uvigo.ei.aibench.core.operation.execution.ExecutionSession;
import es.uvigo.ei.aibench.core.operation.execution.ResultsCollector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class SerialExecutable
extends AbstractExecutable {
    private List<Executable> executables;
    private final List<CollectorAdapterFactory> adapters;

    public SerialExecutable(Executable ... executables) {
        this(Arrays.asList(executables));
    }

    public SerialExecutable(List<Executable> executables) throws IllegalArgumentException {
        if (executables.size() == 0) {
            throw new IllegalArgumentException("There must be at least one executable");
        }
        SerialExecutable.checkElementsNotNull(executables);
        ArrayList<Executable> list = new ArrayList<Executable>();
        CollectorAdapterFactory[] adapters = new CollectorAdapterFactory[executables.size() - 1];
        Iterator<Executable> iter = executables.iterator();
        Executable present = iter.next();
        list.add(present);
        int i = 0;
        while (iter.hasNext()) {
            Executable next = iter.next();
            adapters[i++] = CollectorAdapterFactory.adapt(present, next);
            present = next;
            list.add(present);
        }
        assert (i == adapters.length);
        this.executables = Collections.unmodifiableList(list);
        this.adapters = Arrays.asList(adapters);
    }

    @Override
    public List<Class<?>> getIncomeArgumentTypes() {
        return this.executables.get(0).getIncomeArgumentTypes();
    }

    @Override
    public ExecutionSession openExecutionSession(ResultsCollector collector) {
        return this.executables.get(0).openExecutionSession(this.adaptExecutionSession(0, collector));
    }

    private ResultsCollector adaptExecutionSession(int pos, ResultsCollector originalCollector) {
        if (pos == this.adapters.size()) {
            return originalCollector;
        }
        return this.adapters.get(pos).getAdapter(this.adaptExecutionSession(pos + 1, originalCollector));
    }

    @Override
    public List<Class<?>> getOutcomeArgumentTypes() {
        return this.executables.get(this.executables.size() - 1).getOutcomeArgumentTypes();
    }
}

