/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.aibench;

import es.uvigo.ei.aibench.Launcher;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.apache.log4j.Logger;
import org.platonos.pluginengine.Plugin;
import org.platonos.pluginengine.event.IPluginEngineListener;
import org.platonos.pluginengine.event.PluginEngineEvent;
import org.platonos.pluginengine.event.PluginEngineEventType;

public class SplashFrame
extends JFrame
implements IPluginEngineListener {
    private static Logger logger = Logger.getLogger(SplashFrame.class);
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JProgressBar progress = new JProgressBar();
    private Image fImage;
    private int current = 0;
    private int toStart = 0;

    public SplashFrame() {
        this.initialize();
        this.progress.setStringPainted(true);
        this.progress.setAlignmentX(0.0f);
        this.progress.setMaximum(20);
        this.progress.setString("Initializing plugins...");
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getJContentPane(), "Center");
        this.setSize(this.fImage.getWidth(null), this.fImage.getHeight(null) + 10);
        this.add((Component)this.progress, "South");
        this.setTitle("Welcome to AIBench");
        this.setAlwaysOnTop(true);
        this.setUndecorated(true);
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            URL imageURL;
            block8: {
                imageURL = null;
                if (Launcher.CONFIG.getProperty("splashimage") != null) {
                    imageURL = Launcher.class.getProtectionDomain().getCodeSource().getLocation();
                    try {
                        if (imageURL.getFile().endsWith(".jar")) {
                            imageURL = new URL(imageURL.toString().substring(0, imageURL.toString().lastIndexOf(47)) + "/../" + Launcher.CONFIG.getProperty("splashimage"));
                            break block8;
                        }
                        imageURL = new URL(imageURL + "../" + Launcher.CONFIG.getProperty("splashimage"));
                    }
                    catch (MalformedURLException e1) {
                        System.err.println("Not found the specified splash image, searching in url: " + imageURL.getFile() + "using default");
                        imageURL = SplashFrame.class.getResource("/splash.jpg");
                    }
                } else {
                    imageURL = SplashFrame.class.getResource("/splash.jpg");
                }
            }
            MediaTracker mt = new MediaTracker(this);
            this.fImage = Toolkit.getDefaultToolkit().getImage(imageURL);
            mt.addImage(this.fImage, 0);
            try {
                mt.waitForAll();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.jContentPane = new JPanel(){
                private static final long serialVersionUID = 1L;

                @Override
                public void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    if (SplashFrame.this.fImage != null) {
                        int imwidth = SplashFrame.this.fImage.getWidth(null);
                        int imheight = SplashFrame.this.fImage.getHeight(null);
                        if (imwidth > 0 && imheight > 0) {
                            for (int y = 0; y < this.getHeight(); y += imheight) {
                                for (int x = 0; x < this.getWidth(); x += imwidth) {
                                    g.drawImage(SplashFrame.this.fImage, x, y, null);
                                }
                            }
                        }
                    }
                }
            };
            this.jContentPane.setLayout(null);
            this.jContentPane.setOpaque(true);
            this.jContentPane.setPreferredSize(new Dimension(this.fImage.getWidth(null), this.fImage.getHeight(null)));
        }
        return this.jContentPane;
    }

    @Override
    public void handlePluginEngineEvent(PluginEngineEvent evt) {
        if (!evt.getEventType().equals(PluginEngineEventType.STARTUP)) {
            if (evt.getEventType().equals(PluginEngineEventType.PLUGIN_LOADED)) {
                Plugin plugin = (Plugin)evt.getPayload();
                if (!plugin.isDisabled() && plugin.getStartWhenResolved()) {
                    ++this.toStart;
                    this.progress.setMaximum(this.toStart);
                }
                logger.info("Loaded " + plugin.getName() + "   [version " + plugin.getVersion() + "]");
            } else if (evt.getEventType().equals(PluginEngineEventType.PLUGIN_STARTING)) {
                this.progress.setString("Starting " + evt.getPayload().toString());
            } else if (evt.getEventType().equals(PluginEngineEventType.PLUGIN_STARTED) || evt.getEventType().equals(PluginEngineEventType.PLUGIN_DISABLED)) {
                this.progress.setValue(++this.current);
                if (this.toStart == this.current) {
                    this.setVisible(false);
                    this.dispose();
                }
            }
        }
    }
}

